package cn.xx996.wxsdk.webchat;

import cn.hutool.http.HttpUtil;
import cn.xx996.wxsdk.parameter.QueryPerformanceData;
import com.alibaba.fastjson.JSON;

import java.util.HashMap;
import java.util.Map;

/**
 * @BelongsProject: wx-sdk
 * @BelongsPackage: cn.xx996.wxsdk.webchat
 * @Author: lizeze
 * @CreateTime: 2021-08-17 22:51
 */

public class Analysis {


    /**
     * 获取用户访问小程序日留存
     *
     * @param begin_date   开始日期。格式为 yyyymmdd
     * @param end_date     结束日期，限定查询1天数据，允许设置的最大值为昨日。格式为 yyyymmdd
     * @param access_token 接口调用凭证
     * @return
     */
    public static String getDailyRetain(String begin_date, String end_date, String access_token) {

        return getAnalysis(begin_date, end_date, access_token, "https://api.weixin.qq.com/datacube/getweanalysisappiddailyretaininfo?access_token=%s");

    }

    /**
     * 获取用户访问小程序月留存
     * 只能查询本月之前
     *
     * @param begin_date   开始日期，为自然月第一天。格式为 yyyymmdd
     * @param end_date     结束日期，为自然月最后一天，限定查询一个月数据。格式为 yyyymmdd
     * @param access_token 接口调用凭证
     * @return
     */
    public static String getMonthlyRetain(String begin_date, String end_date, String access_token) {
        return getAnalysis(begin_date, end_date, access_token, "https://api.weixin.qq.com/datacube/getweanalysisappidmonthlyretaininfo?access_token=%s");
    }

    /**
     * 获取用户访问小程序周留存
     * 只能查询本周之前
     *
     * @param begin_date   开始日期，为周一日期。格式为 yyyymmdd
     * @param end_date     结束日期，为周日日期，限定查询一周数据。格式为 yyyymmdd
     * @param access_token 接口调用凭证
     * @return
     */
    public static String getWeeklyRetain(String begin_date, String end_date, String access_token) {
        return getAnalysis(begin_date, end_date, access_token, "https://api.weixin.qq.com/datacube/getweanalysisappidweeklyretaininfo?access_token=%s");
    }

    private static String getAnalysis(String begin_date, String end_date, String access_token, String s) {
        String url = String.format(s, access_token);
        Map<String, Object> map = new HashMap<>();
        map.put("begin_date", begin_date);
        map.put("end_date", end_date);
        return HttpUtil.post(url, JSON.toJSONString(map));
    }

    /**
     * 获取用户访问小程序数据概况
     *
     * @param begin_date   开始日期。格式为 yyyymmdd
     * @param end_date     结束日期，限定查询1天数据，允许设置的最大值为昨日。格式为 yyyymmdd
     * @param access_token 接口调用凭证
     * @return
     */
    public static String getDailySummary(String begin_date, String end_date, String access_token) {

        return getAnalysis(begin_date, end_date, access_token, " https://api.weixin.qq.com/datacube/getweanalysisappiddailysummarytrend?access_token=%s");

    }

    /**
     * 获取用户访问小程序数据日趋势
     *
     * @param begin_date   开始日期。格式为 yyyymmdd
     * @param end_date     结束日期，限定查询1天数据，允许设置的最大值为昨日。格式为 yyyymmdd
     * @param access_token 接口调用凭证
     * @return
     */
    public static String getDailyVisitTrend(String begin_date, String end_date, String access_token) {

        return getAnalysis(begin_date, end_date, access_token, "https://api.weixin.qq.com/datacube/getweanalysisappiddailyvisittrend?access_token=%s");

    }

    /**
     * 获取用户访问小程序数据月趋势(能查询到的最新数据为上一个自然月的数据)
     *
     * @param begin_date   开始日期，为自然月第一天。格式为 yyyymmdd
     * @param end_date     结束日期，为自然月最后一天，限定查询一个月的数据。格式为 yyyymmdd
     * @param access_token 接口调用凭证
     * @return
     */
    public static String getMonthlyVisitTrend(String begin_date, String end_date, String access_token) {

        return getAnalysis(begin_date, end_date, access_token, "https://api.weixin.qq.com/datacube/getweanalysisappidmonthlyvisittrend?access_token=%s");

    }


    /**
     * 获取用户访问小程序数据周趋势
     *
     * @param begin_date   开始日期，为周一日期。格式为 yyyymmdd
     * @param end_date     结束日期，为周日日期，限定查询一周数据。格式为 yyyymmdd
     * @param access_token 接口调用凭证
     * @return
     */
    public static String getWeeklyVisitTrend(String begin_date, String end_date, String access_token) {

        return getAnalysis(begin_date, end_date, access_token, "https://api.weixin.qq.com/datacube/getweanalysisappidweeklyvisittrend?access_token=%s");

    }

    /**
     * 获取小程序启动性能，运行性能等数据
     *
     * @param queryPerformanceData 参照官方文档参数格式
     * @param access_token         接口调用凭证
     * @return
     */
    public static String getPerformanceData(QueryPerformanceData queryPerformanceData, String access_token) {

        String url = String.format("https://api.weixin.qq.com/wxa/business/performance/boot?access_token=%s", access_token);
        return HttpUtil.post(url, JSON.toJSONString(queryPerformanceData));
    }

    /**
     * 获取小程序新增或活跃用户的画像分布数据
     *
     * @param begin_date   开始日期，为周一日期。格式为 yyyymmdd
     * @param end_date     结束日期，开始日期与结束日期相差的天数限定为0/6/29，分别表示查询最近1/7/30天数据，允许设置的最大值为昨日。格式为 yyyymmdd
     * @param access_token 接口调用凭证
     * @return
     */
    public static String getUserPortrait(String begin_date, String end_date, String access_token) {


        return getAnalysis(begin_date, end_date, access_token, "https://api.weixin.qq.com/datacube/getweanalysisappiduserportrait?access_token=%s");

    }

    /**
     * 获取用户小程序访问分布数据
     *
     * @param begin_date   开始日期。格式为 yyyymmdd
     * @param end_date     结束日期，限定查询 1 天数据，允许设置的最大值为昨日。格式为 yyyymmdd
     * @param access_token 接口调用凭证
     * @return
     */
    public static String getVisitDistribution(String begin_date, String end_date, String access_token) {
        return getAnalysis(begin_date, end_date, access_token, "https://api.weixin.qq.com/datacube/getweanalysisappidvisitdistribution?access_token=%s");
    }

    /**
     * 访问页面
     *
     * @param begin_date   开始日期。格式为 yyyymmdd
     * @param end_date     结束日期，限定查询1天数据，允许设置的最大值为昨日。格式为 yyyymmdd
     * @param access_token 接口调用凭证
     * @return
     */
    public static String getVisitPage(String begin_date, String end_date, String access_token) {
        return getAnalysis(begin_date, end_date, access_token, "https://api.weixin.qq.com/datacube/getweanalysisappidvisitpage?access_token=%s");
    }


}
