/*
 * Decompiled with CFR 0.152.
 */
package cn.xx996.email;

import cn.xx996.email.EmailAttachment;
import cn.xx996.email.EmailImage;
import cn.xx996.email.ReceiveAccount;
import cn.xx996.email.entity.ImageParameter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class SendEmail {
    private MimeMultipart mm;
    private MimeMessage message;
    private String personal;
    private String emailAddress;
    private String emailPassword;
    private String emailSMTPHost;
    private boolean debug;
    private Session session;
    private List<ReceiveAccount> receiveAccounts;

    public SendEmail(String emailAddress, String emailPassword, String emailSMTPHost) throws UnsupportedEncodingException, MessagingException {
        this.init(emailAddress, emailPassword, emailSMTPHost);
    }

    private void init(String emailAddress, String emailPassword, String emailSMTPHost) throws MessagingException, UnsupportedEncodingException {
        this.emailAddress = emailAddress;
        this.emailPassword = emailPassword;
        this.emailSMTPHost = emailSMTPHost;
        this.receiveAccounts = new ArrayList<ReceiveAccount>();
        this.message = new MimeMessage(this.createSession());
        this.mm = new MimeMultipart();
        this.message.setFrom((Address)new InternetAddress(emailAddress, this.personal, "UTF-8"));
    }

    public SendEmail(String emailAddress, String emailPassword, String emailSMTPHost, boolean debug) throws UnsupportedEncodingException, MessagingException {
        this.debug = debug;
        this.init(emailAddress, emailPassword, emailSMTPHost);
    }

    private Session createSession() {
        Properties props = new Properties();
        props.setProperty("mail.transport.protocol", "smtp");
        props.setProperty("mail.smtp.host", this.emailSMTPHost);
        props.setProperty("mail.smtp.auth", "true");
        Session session = Session.getInstance((Properties)props);
        session.setDebug(this.debug);
        this.session = session;
        return session;
    }

    public void addReceive(ReceiveAccount receiveAccount) throws UnsupportedEncodingException, MessagingException {
        if (receiveAccount != null) {
            this.message.setRecipient(receiveAccount.getRecipientType(), (Address)new InternetAddress(receiveAccount.getEmailAddress(), receiveAccount.getPersonal(), "UTF-8"));
        }
    }

    public void setSubject(String subject) throws MessagingException {
        this.message.setSubject(subject, "UTF-8");
    }

    public void addReceive(List<ReceiveAccount> receiveAccounts) throws UnsupportedEncodingException, MessagingException {
        if (receiveAccounts != null && receiveAccounts.size() > 0) {
            for (int i = 0; i < receiveAccounts.size(); ++i) {
                this.addReceive(receiveAccounts.get(i));
            }
        }
    }

    public void addImage(String imagePath, String content) throws MessagingException {
        this.mm.addBodyPart((BodyPart)EmailImage.addImage(new ImageParameter(imagePath, content)));
    }

    public void addImage(List<ImageParameter> images) throws MessagingException {
        for (int i = 0; i < images.size(); ++i) {
            this.addImage(images.get(i).getImagePath(), images.get(i).getContent());
        }
    }

    public void addAttachment(String attachmentPath) throws UnsupportedEncodingException, MessagingException {
        this.mm.addBodyPart((BodyPart)EmailAttachment.addAttachment(attachmentPath));
    }

    public void addContent(String content) throws MessagingException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setContent((Object)content, "text/html;charset=UTF-8");
        this.mm.addBodyPart((BodyPart)mimeBodyPart);
    }

    public void saveChange() throws MessagingException {
        this.mm.setSubType("mixed");
        this.message.setContent((Multipart)this.mm);
        this.message.setSentDate(new Date());
        this.message.saveChanges();
    }

    public void sendEmail() throws MessagingException {
        Transport transport = this.session.getTransport();
        transport.connect(this.emailAddress, this.emailPassword);
        transport.sendMessage((Message)this.message, this.message.getAllRecipients());
        transport.close();
    }

    public List<ReceiveAccount> getReceiveAccounts() {
        return this.receiveAccounts;
    }

    public void setReceiveAccounts(List<ReceiveAccount> receiveAccounts) {
        this.receiveAccounts = receiveAccounts;
    }

    public String getPersonal() {
        return this.personal;
    }

    public void setPersonal(String personal) {
        this.personal = personal;
    }
}

