/*
 * Decompiled with CFR 0.152.
 */
package cn.xx996.auth;

import cn.dev33.satoken.stp.SaTokenInfo;
import cn.dev33.satoken.stp.StpUtil;
import cn.xx996.auth.LoginCheck;
import cn.xx996.auth.LoginHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class PermissionInterceptor
extends HandlerInterceptorAdapter {
    @Value(value="${spring.profiles.active}")
    private String env;
    private final String devProfile = "dev";
    @Autowired(required=false)
    private LoginHandler loginHandler;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.env.equals("dev")) {
            return true;
        }
        if (request.getMethod().equals(RequestMethod.OPTIONS.name())) {
            response.setStatus(HttpStatus.OK.value());
            return true;
        }
        if (this.loginHandler != null) {
            return this.loginHandler.preHandle(request, response, handler);
        }
        if (this.getLoginCheck(handler)) {
            SaTokenInfo saTokenInfo = StpUtil.getTokenInfo();
            if (!saTokenInfo.isLogin.booleanValue()) {
                throw new RuntimeException();
            }
            Long tokenTimeOut = saTokenInfo.getTokenTimeout();
            if (tokenTimeOut < 300L) {
                response.setHeader("TokenTimeout", tokenTimeOut.toString());
            }
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        super.postHandle(request, response, handler, modelAndView);
    }

    private boolean getLoginCheck(Object handler) throws ClassNotFoundException {
        if (handler instanceof HandlerMethod) {
            LoginCheck loginCheckMethod = ((HandlerMethod)handler).getMethod().getAnnotation(LoginCheck.class);
            if (loginCheckMethod != null) {
                return loginCheckMethod.value();
            }
            LoginCheck loginCheckType = ((HandlerMethod)handler).getBeanType().getAnnotation(LoginCheck.class);
            if (loginCheckType != null) {
                return loginCheckType.value();
            }
        }
        return true;
    }
}

