/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.sso.server.storage;

import cn.xuqiudong.common.util.JsonUtil;
import cn.xuqiudong.sso.server.storage.StorageStrategy;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"sso.storageStrategy"}, havingValue="redis")
public class RedisStorageStrategy<T>
implements StorageStrategy<T> {
    private Logger logger = LoggerFactory.getLogger(RedisStorageStrategy.class);
    private static final String REDIS_PREFIX = "sso-server:";
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    private String getKey(String cacheName, String key) {
        return REDIS_PREFIX + cacheName + ":" + key;
    }

    public void storage(String cacheName, String key, T data, int expire) {
        String text = JsonUtil.toJson(data);
        this.stringRedisTemplate.opsForValue().set((Object)this.getKey(cacheName, key), (Object)text, (long)expire, TimeUnit.SECONDS);
    }

    public T getData(String cacheName, String key, Class<T> clazz) {
        String text = (String)this.stringRedisTemplate.opsForValue().get((Object)this.getKey(cacheName, key));
        if (StringUtils.isEmpty((CharSequence)text)) {
            return null;
        }
        Object data = JsonUtil.jsonToObject((String)text, clazz);
        return (T)data;
    }

    public T refresh(String cacheName, String key, int expire, Class<T> clazz) {
        Object data = this.getData(cacheName, key, clazz);
        if (data == null) {
            return null;
        }
        this.stringRedisTemplate.expire((Object)this.getKey(cacheName, key), (long)expire, TimeUnit.SECONDS);
        return (T)data;
    }

    public T remove(String cacheName, String key, Class<T> clazz) {
        String text = (String)this.stringRedisTemplate.opsForValue().get((Object)this.getKey(cacheName, key));
        if (StringUtils.isEmpty((CharSequence)text)) {
            return null;
        }
        this.stringRedisTemplate.delete((Object)this.getKey(cacheName, key));
        Object data = JsonUtil.jsonToObject((String)text, clazz);
        return (T)data;
    }

    public void storage2SetData(String cacheName, String key, String data) {
        this.stringRedisTemplate.opsForSet().add((Object)this.getKey(cacheName, key), (Object[])new String[]{data});
    }

    public Set<String> getSetData(String cacheName, String key) {
        Set accessTokenSet = this.stringRedisTemplate.opsForSet().members((Object)this.getKey(cacheName, key));
        return accessTokenSet;
    }

    public void cleanSchedule() {
    }
}

