/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.sso.server.storage;

import cn.xuqiudong.sso.server.storage.StorageStrategy;
import cn.xuqiudong.sso.server.storage.model.LocalData;
import cn.xuqiudong.sso.server.storage.model.LocalDataCache;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"sso.storageStrategy"}, havingValue="local", matchIfMissing=true)
public class LocalStorageStrategy<T>
implements StorageStrategy<T> {
    private Logger logger = LoggerFactory.getLogger(LocalStorageStrategy.class);
    public static final String CLEAN_CRON = "0 */5 * * * ?";

    public void storage(String cacheName, String key, T data, int expire) {
        LocalData localData = new LocalData(data, expire);
        LocalDataCache.cache((String)cacheName, (String)key, (LocalData)localData);
    }

    public T getData(String cacheName, String key, Class<T> clazz) {
        LocalData localData = LocalDataCache.get((String)cacheName, (String)key);
        if (localData == null || localData.isExpire()) {
            return null;
        }
        return (T)localData.getData();
    }

    public T refresh(String cacheName, String key, int expire, Class<T> clazz) {
        LocalData localData = LocalDataCache.get((String)cacheName, (String)key);
        if (localData == null || localData.isExpire()) {
            return null;
        }
        localData.refresh();
        return (T)localData.getData();
    }

    public T remove(String cacheName, String key, Class<T> clazz) {
        LocalData remove = LocalDataCache.remove((String)cacheName, (String)key);
        return (T)remove.getData();
    }

    public void storage2SetData(String cacheName, String key, String data) {
        LocalData localData = LocalDataCache.get((String)cacheName, (String)key);
        if (localData == null) {
            HashSet<String> set = new HashSet<String>();
            set.add(data);
            localData = new LocalData(set, 28800);
            LocalDataCache.cache((String)cacheName, (String)key, (LocalData)localData);
        } else {
            HashSet hashSet = (HashSet)localData.getData();
            hashSet.add(data);
            localData.refresh();
        }
    }

    public Set<String> getSetData(String cacheName, String key) {
        LocalData localData = LocalDataCache.get((String)cacheName, (String)key);
        return (Set)localData.getData();
    }

    @Scheduled(cron="0 */5 * * * ?")
    public void cleanSchedule() {
        this.logger.info("start clean local data");
        LocalDataCache.checkAndExpire();
    }
}

