/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.sso.server.session.impl;

import cn.xuqiudong.sso.common.model.SsoUser;
import cn.xuqiudong.sso.server.config.SsoConfiguration;
import cn.xuqiudong.sso.server.session.TicketGrantingTicketManager;
import cn.xuqiudong.sso.server.storage.StorageStrategy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TicketGrantingTicketManagerImpl
implements TicketGrantingTicketManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private StorageStrategy<SsoUser> ssoUserStorageStrategy;
    @Resource
    private SsoConfiguration ssoConfiguration;

    public int expire() {
        return this.ssoConfiguration.getTimeout();
    }

    public String cacheName() {
        return "tgt";
    }

    public void storage(String tgt, SsoUser user) {
        this.ssoUserStorageStrategy.storage(this.cacheName(), tgt, (Object)user, this.expire());
    }

    public SsoUser getAndRefresh(String tgt) {
        return (SsoUser)this.ssoUserStorageStrategy.refresh(this.cacheName(), tgt, this.expire(), SsoUser.class);
    }

    public void remove(String tgt) {
        this.ssoUserStorageStrategy.remove(this.cacheName(), tgt, SsoUser.class);
        this.logger.debug("\u5220\u9664tgt\uff1a{}", (Object)tgt);
    }
}

