/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.sso.server.session.impl;

import cn.xuqiudong.sso.common.model.RefreshTokenContent;
import cn.xuqiudong.sso.server.config.SsoConfiguration;
import cn.xuqiudong.sso.server.session.RefreshTokenManager;
import cn.xuqiudong.sso.server.storage.StorageStrategy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RefreshTokenManagerImpl
implements RefreshTokenManager {
    private Logger logger = LoggerFactory.getLogger(RefreshTokenManagerImpl.class);
    @Resource
    private StorageStrategy<RefreshTokenContent> storageStrategy;
    @Resource
    private SsoConfiguration ssoConfiguration;

    public int expire() {
        return this.ssoConfiguration.getTimeout();
    }

    public String cacheName() {
        return "refresh-token";
    }

    public void storage(String refreshToken, RefreshTokenContent refreshTokenContent) {
        this.storageStrategy.storage(this.cacheName(), refreshToken, (Object)refreshTokenContent, this.expire());
    }

    public RefreshTokenContent validate(String refreshToken) {
        RefreshTokenContent refreshTokenContent = (RefreshTokenContent)this.storageStrategy.remove(this.cacheName(), refreshToken, RefreshTokenContent.class);
        if (refreshTokenContent == null) {
            refreshTokenContent = this.getTemporaryStorageRefreshToken(refreshToken);
        }
        return refreshTokenContent;
    }

    public void temporaryStorageRefreshToken(String refreshToken, RefreshTokenContent refreshTokenContent) {
        this.storageStrategy.storage(this.temporaryStorageCacheName(), refreshToken, (Object)refreshTokenContent, 60);
    }

    public RefreshTokenContent getTemporaryStorageRefreshToken(String refreshToken) {
        return (RefreshTokenContent)this.storageStrategy.getData(this.temporaryStorageCacheName(), refreshToken, RefreshTokenContent.class);
    }

    private String temporaryStorageCacheName() {
        return "temporary-" + this.cacheName();
    }
}

