/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.sso.server.session.impl;

import cn.xuqiudong.sso.common.model.AuthorizationCode;
import cn.xuqiudong.sso.server.config.SsoConfiguration;
import cn.xuqiudong.sso.server.session.CodeManager;
import cn.xuqiudong.sso.server.storage.StorageStrategy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CodeManagerImpl
implements CodeManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private StorageStrategy<AuthorizationCode> storageStrategy;
    @Resource
    private SsoConfiguration ssoConfiguration;

    public int expire() {
        return this.ssoConfiguration.getCodeTimeout();
    }

    public void storage(String code, AuthorizationCode authorizationCode) {
        this.storageStrategy.storage(this.cacheName(), code, (Object)authorizationCode, this.expire());
        this.logger.info("\u672c\u5730\u6388\u6743\u7801[{}]\u5b58\u50a8\u6210\u529f", (Object)code);
    }

    public AuthorizationCode validateAndRemove(String code) {
        AuthorizationCode data = (AuthorizationCode)this.storageStrategy.getData(this.cacheName(), code, AuthorizationCode.class);
        this.storageStrategy.remove(this.cacheName(), code, AuthorizationCode.class);
        return data;
    }

    public String cacheName() {
        return "code";
    }
}

