/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.sso.server.session.impl;

import cn.xuqiudong.sso.common.model.AccessTokenContent;
import cn.xuqiudong.sso.common.model.AuthorizationCode;
import cn.xuqiudong.sso.server.config.SsoConfiguration;
import cn.xuqiudong.sso.server.session.AccessTokenManager;
import cn.xuqiudong.sso.server.storage.StorageStrategy;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AccessTokenManagerImpl
implements AccessTokenManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private SsoConfiguration ssoConfiguration;
    @Resource
    private StorageStrategy<AccessTokenContent> accessTokenContentStorageStrategy;

    public int expire() {
        return this.ssoConfiguration.getAccessTokenTimeout();
    }

    public String cacheName() {
        return "access-token";
    }

    public String tgtAndAtCacheName() {
        return this.cacheName() + "s:with-tgt";
    }

    public void storage(String accessToken, AccessTokenContent tokenInfo) {
        this.accessTokenContentStorageStrategy.storage(this.cacheName(), accessToken, (Object)tokenInfo, this.expire());
        String tgt = tokenInfo.getAuthorizationCode().getTgt();
        this.accessTokenContentStorageStrategy.storage2SetData(this.tgtAndAtCacheName(), tgt, accessToken);
        this.logger.info("\u8c03\u7528\u51ed\u8bc1\u5b58\u50a8\u6210\u529f, accessToken:{}, \u5e76\u4fdd\u5b58\u5230tgt\u5bf9\u5e94\u7684\u7f13\u5b58,tgt\uff1a{}", (Object)accessToken, (Object)tgt);
    }

    public boolean refresh(String accessToken) {
        return this.accessTokenContentStorageStrategy.refresh(this.cacheName(), accessToken, this.expire(), AccessTokenContent.class) != null;
    }

    public AccessTokenContent get(String accessToken) {
        return (AccessTokenContent)this.accessTokenContentStorageStrategy.getData(this.cacheName(), accessToken, AccessTokenContent.class);
    }

    public void remove(String tgt) {
        Set accessTokenSet = this.accessTokenContentStorageStrategy.getSetData(this.tgtAndAtCacheName(), tgt);
        if (CollectionUtils.isEmpty((Collection)accessTokenSet)) {
            return;
        }
        accessTokenSet.forEach(accessToken -> {
            AccessTokenContent accessTokenInfo = this.get(accessToken);
            if (accessTokenInfo == null) {
                return;
            }
            AuthorizationCode authorizationCode = accessTokenInfo.getAuthorizationCode();
            if (authorizationCode == null || !authorizationCode.isNotifyLogout()) {
                return;
            }
            String logoutUrl = this.ssoConfiguration.getLogoutUrl(accessTokenInfo.getAppId());
            if (StringUtils.isBlank((CharSequence)logoutUrl)) {
                logoutUrl = authorizationCode.getRedirectUri();
            }
            this.logger.debug("\u53d1\u8d77\u5ba2\u6237\u7aef\u767b\u51fa\u8bf7\u6c42, accessToken:{}, url:{}", accessToken, (Object)logoutUrl);
            this.sendLogoutRequest(logoutUrl, accessToken);
        });
    }
}

