/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.sso.server.session;

import cn.xuqiudong.common.util.CookieUtil;
import cn.xuqiudong.sso.common.model.SsoUser;
import cn.xuqiudong.sso.server.session.AccessTokenManager;
import cn.xuqiudong.sso.server.session.TicketGrantingTicketManager;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class SessionManager {
    @Resource
    private TicketGrantingTicketManager ticketGrantingTicketManager;
    @Resource
    private AccessTokenManager accessTokenManager;

    public String createTgt(SsoUser user, HttpServletRequest request, HttpServletResponse response) {
        String tgt = this.getCookieTgt(request);
        if (StringUtils.isEmpty((CharSequence)tgt)) {
            tgt = this.ticketGrantingTicketManager.generate(user);
            CookieUtil.set((HttpServletResponse)response, (String)"TGC", (String)tgt, (boolean)true);
            return tgt;
        }
        if (this.ticketGrantingTicketManager.getAndRefresh(tgt) == null) {
            this.ticketGrantingTicketManager.storage(tgt, user);
            return tgt;
        }
        return tgt;
    }

    private String getCookieTgt(HttpServletRequest request) {
        String tgt = CookieUtil.getValue((HttpServletRequest)request, (String)"TGC");
        return tgt;
    }

    public String getTgt(HttpServletRequest request) {
        String tgt = this.getCookieTgt(request);
        if (StringUtils.isEmpty((CharSequence)tgt) || this.ticketGrantingTicketManager.getAndRefresh(tgt) == null) {
            return null;
        }
        return tgt;
    }

    public void invalidate(HttpServletRequest request, HttpServletResponse response) {
        String tgt = this.getCookieTgt(request);
        if (StringUtils.isEmpty((CharSequence)tgt)) {
            return;
        }
        this.ticketGrantingTicketManager.remove(tgt);
        CookieUtil.remove((HttpServletRequest)request, (HttpServletResponse)response, (String)"TGC");
        this.accessTokenManager.remove(tgt);
    }
}

