/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.sso.server.service.impl;

import cn.xuqiudong.common.base.model.BaseResponse;
import cn.xuqiudong.common.util.encrypt.PasswordUtils;
import cn.xuqiudong.sso.common.model.SsoUser;
import cn.xuqiudong.sso.server.service.SsoUserService;
import javax.annotation.Resource;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class SsoUserServiceImpl
implements SsoUserService {
    @Resource
    private JdbcTemplate jdbcTemplate;

    public BaseResponse<SsoUser> login(String group, String username, String password) {
        SsoUser user = this.findUserByUsername(group, username);
        if (user == null) {
            return BaseResponse.error((String)"\u4e0d\u5b58\u5728\u7684\u7528\u6237");
        }
        boolean validatePassword = PasswordUtils.validatePassword((String)password, (String)user.getPassword());
        if (!validatePassword) {
            return BaseResponse.error((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        }
        return BaseResponse.success((Object)user);
    }

    private SsoUser findUserByUsername(String group, String username) {
        String sql = "SELECT a.id, a.username, a.password, a.group  FROM sso_user a WHERE a.username = ? and a.group = ?  LIMIT 1 ";
        try {
            return (SsoUser)this.jdbcTemplate.queryForObject(sql, (RowMapper)new BeanPropertyRowMapper(SsoUser.class), new Object[]{username, group});
        }
        catch (Exception e) {
            return null;
        }
    }
}

