/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.sso.server.service;

import cn.xuqiudong.common.base.model.BaseResponse;
import cn.xuqiudong.common.base.vo.BooleanWithMsg;
import cn.xuqiudong.sso.common.enums.GrantTypeEnum;
import cn.xuqiudong.sso.common.model.AccessTokenContent;
import cn.xuqiudong.sso.common.model.AuthorizationCode;
import cn.xuqiudong.sso.common.model.RpcAccessToken;
import cn.xuqiudong.sso.common.model.SsoUser;
import cn.xuqiudong.sso.server.config.SsoConfiguration;
import cn.xuqiudong.sso.server.model.AppClient;
import cn.xuqiudong.sso.server.service.SsoUserService;
import cn.xuqiudong.sso.server.session.AccessTokenManager;
import cn.xuqiudong.sso.server.session.CodeManager;
import cn.xuqiudong.sso.server.session.RefreshTokenManager;
import cn.xuqiudong.sso.server.session.TicketGrantingTicketManager;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class Oauth2Service {
    @Resource
    private CodeManager codeManager;
    @Resource
    private TicketGrantingTicketManager ticketGrantingTicketManager;
    @Resource
    private SsoUserService userService;
    @Resource
    private AccessTokenManager accessTokenManager;
    @Resource
    private RefreshTokenManager refreshTokenManager;
    @Resource
    private SsoConfiguration ssoConfiguration;

    public BaseResponse<RpcAccessToken> validateAndGenerateToken(String grantType, String code, String username, String password, String appId) {
        BaseResponse accessTokenContentBaseResponse = this.validateAuth(grantType, code, username, password, appId);
        if (!accessTokenContentBaseResponse.isSuccess()) {
            return BaseResponse.error((String)accessTokenContentBaseResponse.getMsg());
        }
        RpcAccessToken token = this.generateRpcAccessToken((AccessTokenContent)accessTokenContentBaseResponse.getData(), null);
        return BaseResponse.success((Object)token);
    }

    private BaseResponse<AccessTokenContent> validateAuth(String grantType, String code, String username, String password, String appId) {
        AccessTokenContent authDto = null;
        if (GrantTypeEnum.AUTHORIZATION_CODE.name().equals(grantType)) {
            AuthorizationCode authorizationCode = this.codeManager.validateAndRemove(code);
            if (authorizationCode == null) {
                return BaseResponse.error((String)"code\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u8fc7\u671f");
            }
            SsoUser user = this.ticketGrantingTicketManager.getAndRefresh(authorizationCode.getTgt());
            if (user == null) {
                return BaseResponse.error((String)"\u670d\u52a1\u7aefsession\u5df2\u8fc7\u671f");
            }
            authDto = new AccessTokenContent(authorizationCode, user, appId);
        } else if (GrantTypeEnum.PASSWORD.name().equals(grantType)) {
            String group = ((AppClient)this.ssoConfiguration.getClientMap().get(appId)).getGroup();
            BaseResponse loginResult = this.userService.login(group, username, password);
            if (!loginResult.isSuccess()) {
                return BaseResponse.error((String)loginResult.getMsg());
            }
            SsoUser user = (SsoUser)loginResult.getData();
            String tgt = this.ticketGrantingTicketManager.generate((SsoUser)loginResult.getData());
            AuthorizationCode codeContent = new AuthorizationCode(tgt, false, null);
            authDto = new AccessTokenContent(codeContent, user, appId);
        }
        return BaseResponse.success(authDto);
    }

    public RpcAccessToken generateRpcAccessToken(AccessTokenContent accessTokenContent, String accessToken) {
        if (accessToken == null || !this.accessTokenManager.refresh(accessToken)) {
            accessToken = this.accessTokenManager.generate(accessTokenContent);
        }
        String refreshToken = this.refreshTokenManager.generate(accessTokenContent, accessToken);
        int timeout = this.ssoConfiguration.getTimeout() / 2;
        return new RpcAccessToken(accessToken, timeout, refreshToken, accessTokenContent.getUser());
    }

    public BooleanWithMsg validateParam(String grantType, String code, String username, String password) {
        if (GrantTypeEnum.AUTHORIZATION_CODE.name().equals(grantType)) {
            if (StringUtils.isEmpty((CharSequence)code)) {
                return BooleanWithMsg.fail((String)"code\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if (GrantTypeEnum.PASSWORD.name().equals(grantType)) {
            if (StringUtils.isEmpty((CharSequence)username) || StringUtils.isEmpty((CharSequence)password)) {
                return BooleanWithMsg.fail((String)"username\u548cpassword\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            return BooleanWithMsg.fail((String)"\u6388\u6743\u65b9\u5f0f\u4e0d\u652f\u6301");
        }
        return BooleanWithMsg.success();
    }
}

