/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.sso.server.service;

import cn.xuqiudong.sso.server.config.SsoConfiguration;
import cn.xuqiudong.sso.server.model.AppClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class ClientConfigService {
    private static final Logger logger = LoggerFactory.getLogger(ClientConfigService.class);
    private static final long FIXED_DELAY_SECOND = 300L;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    public SsoConfiguration ssoConfiguration;
    private static final String SELECT_SQL = "SELECT a.app_id AS id, a.group, a.secret, a.logout_url AS logoutUrl FROM client_config a WHERE a.enabled = 1 ";

    @Scheduled(initialDelay=300L, fixedDelay=300L, timeUnit=TimeUnit.SECONDS)
    public void updateClientsConfigSchedule() {
        logger.info("\u81ea\u52a8\u66f4\u65b0\u6570\u636e\u5e93\u91cc\u7684sso client\u5217\u8868\u5230\u914d\u7f6e\u4fe1\u606f\u4e2d");
        this.updateClientsConfig();
    }

    @PostConstruct
    private void initAllClient() {
        this.updateClientsConfig();
        if (this.ssoConfiguration.getClientMap().isEmpty()) {
            throw new IllegalStateException("\u5c1a\u672a\u914d\u7f6e\u53ef\u7528\u7684sso\u5ba2\u6237\u7aef\uff0c \u8bf7\u524d\u5f80\u914d\u7f6e\u6587\u4ef6\u6216\u6570\u636e\u5e93\u914d\u7f6e clients");
        }
        logger.info("\u521d\u59cb\u5316\u5168\u90e8\u7684sso \u5ba2\u6237\u7aef\uff1b \u6570\u91cf\u4e3a{}", (Object)this.ssoConfiguration.getClientMap().size());
    }

    public List<AppClient> allClients() {
        return this.jdbcTemplate.query(SELECT_SQL, (RowMapper)new BeanPropertyRowMapper(AppClient.class));
    }

    public void updateClientsConfig() {
        ArrayList configClients = new ArrayList(this.ssoConfiguration.getClients());
        List appClients = this.allClients();
        configClients.addAll(appClients);
        Map<String, AppClient> collect = configClients.stream().collect(Collectors.toMap(AppClient::getId, c -> c));
        this.ssoConfiguration.setClientMap(collect);
    }
}

