/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.sso.server.controller;

import cn.xuqiudong.common.base.model.BaseResponse;
import cn.xuqiudong.common.base.vo.BooleanWithMsg;
import cn.xuqiudong.sso.common.model.AccessTokenContent;
import cn.xuqiudong.sso.common.model.RefreshTokenContent;
import cn.xuqiudong.sso.common.model.RpcAccessToken;
import cn.xuqiudong.sso.common.model.SsoUser;
import cn.xuqiudong.sso.server.controller.BaseSsoController;
import cn.xuqiudong.sso.server.service.AppService;
import cn.xuqiudong.sso.server.service.Oauth2Service;
import cn.xuqiudong.sso.server.session.RefreshTokenManager;
import cn.xuqiudong.sso.server.session.TicketGrantingTicketManager;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class Oauth2Controller
extends BaseSsoController {
    @Resource
    private AppService appService;
    @Resource
    private Oauth2Service oauth2Service;
    @Resource
    private RefreshTokenManager refreshTokenManager;
    @Resource
    private TicketGrantingTicketManager ticketGrantingTicketManager;

    @RequestMapping(value={"/oauth2/access_token"})
    public BaseResponse<RpcAccessToken> accessToken(@RequestParam(value="grantType", required=true) String grantType, @RequestParam(value="appId", required=true) String appId, @RequestParam(value="appSecret", required=true) String appSecret, @RequestParam(value="code", required=false) String code, @RequestParam(value="username", required=false) String username, @RequestParam(value="password", required=false) String password) {
        BooleanWithMsg msg = this.oauth2Service.validateParam(grantType, code, username, password);
        if (!msg.isSuccess()) {
            return BaseResponse.error((String)msg.getMessage());
        }
        BooleanWithMsg appIdMsg = this.appService.validate(appId, appSecret);
        if (!appIdMsg.isSuccess()) {
            return BaseResponse.error((String)appIdMsg.getMessage());
        }
        BaseResponse data = this.oauth2Service.validateAndGenerateToken(grantType, code, username, password, appId);
        return data;
    }

    @RequestMapping(value={"/oauth2/refresh_token"})
    public BaseResponse<RpcAccessToken> refreshToken(@RequestParam(value="appId", required=true) String appId, @RequestParam(value="refreshToken", required=true) String refreshToken) {
        if (!this.appService.checkAppId(appId)) {
            return BaseResponse.error((String)"\u975e\u6cd5\u5e94\u7528");
        }
        RefreshTokenContent refreshTokenContent = this.refreshTokenManager.validate(refreshToken);
        if (refreshTokenContent == null) {
            return BaseResponse.error((String)"refreshToken\u9519\u8bef\u6216\u5df2\u8fc7\u671f");
        }
        AccessTokenContent accessTokenContent = refreshTokenContent.getAccessTokenContent();
        if (!StringUtils.equals((CharSequence)appId, (CharSequence)accessTokenContent.getAppId())) {
            return BaseResponse.error((String)"\u975e\u6cd5\u5e94\u7528");
        }
        SsoUser user = this.ticketGrantingTicketManager.getAndRefresh(accessTokenContent.getAuthorizationCode().getTgt());
        if (user == null) {
            return BaseResponse.error((String)"\u670d\u52a1\u7aefsession\u5df2\u8fc7\u671f");
        }
        if (refreshTokenContent.isRefreshDuration() && refreshTokenContent.getNewRpcAccessToken() != null) {
            return BaseResponse.success((Object)refreshTokenContent.getNewRpcAccessToken());
        }
        RpcAccessToken rpcAccessToken = this.oauth2Service.generateRpcAccessToken(accessTokenContent, refreshTokenContent.getAccessToken());
        refreshTokenContent.setNewRpcAccessToken(rpcAccessToken);
        this.refreshTokenManager.temporaryStorageRefreshToken(refreshToken, refreshTokenContent);
        return BaseResponse.success((Object)rpcAccessToken);
    }
}

