/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.sso.server.controller;

import cn.xuqiudong.common.base.model.BaseResponse;
import cn.xuqiudong.sso.common.model.SsoUser;
import cn.xuqiudong.sso.server.controller.BaseSsoController;
import cn.xuqiudong.sso.server.service.AppService;
import cn.xuqiudong.sso.server.service.IndexService;
import cn.xuqiudong.sso.server.service.SsoUserService;
import cn.xuqiudong.sso.server.session.SessionManager;
import cn.xuqiudong.sso.server.storage.model.LocalDataCache;
import java.io.UnsupportedEncodingException;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class IndexController
extends BaseSsoController {
    @Resource
    private AppService appService;
    @Resource
    private SsoUserService userService;
    @Resource
    private SessionManager sessionManager;
    @Resource
    private IndexService indexService;

    @GetMapping(value={"logout"})
    public String logout(@RequestParam(value="redirectUri", required=true) String redirectUri) {
        this.sessionManager.invalidate(this.servletRequest, this.servletResponse);
        return "redirect:" + redirectUri;
    }

    @GetMapping(value={"/login"})
    public String login(@RequestParam(value="redirectUri", required=true) String redirectUri, @RequestParam(value="appId", required=true) String appId, Model model) throws UnsupportedEncodingException {
        String tgt = this.sessionManager.getTgt(this.servletRequest);
        if (StringUtils.isEmpty((CharSequence)tgt)) {
            return this.goLoginPath(redirectUri, appId, model, null);
        }
        return this.indexService.generateCodeAndRedirect(redirectUri, tgt);
    }

    @PostMapping(value={"/login"})
    public String login(@RequestParam(value="redirectUri", required=true) String redirectUri, @RequestParam(value="appId", required=true) String appId, @RequestParam(value="group", defaultValue="") String group, @RequestParam(required=false) boolean rememberMe, @RequestParam String username, @RequestParam String password, Model model) throws UnsupportedEncodingException {
        if (!this.appService.checkAppId(appId)) {
            return this.goLoginPath(redirectUri, appId, model, "\u975e\u6cd5\u7684\u5e94\u7528");
        }
        BaseResponse result = this.userService.login(group, username, password);
        if (!result.isSuccess()) {
            return this.goLoginPath(redirectUri, appId, model, result.getMsg());
        }
        String tgt = this.sessionManager.createTgt((SsoUser)result.getData(), this.servletRequest, this.servletResponse);
        return this.indexService.generateCodeAndRedirect(redirectUri, tgt);
    }

    @GetMapping(value={"", "/"})
    public String home() throws UnsupportedEncodingException {
        String params = "?redirectUri=" + this.servletRequest.getScheme() + "://" + this.servletRequest.getServerName() + ":" + this.servletRequest.getServerPort() + "/index";
        params = params + "&" + "appId" + "=testAppId";
        return "redirect:/login" + params;
    }

    @GetMapping(value={"/index"})
    public String index(String code, Model model) {
        model.addAttribute("code", (Object)code);
        LocalDataCache.printCache();
        return "index";
    }
}

