/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.sso.server.config;

import cn.xuqiudong.sso.server.model.AppClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="sso")
public class SsoConfiguration {
    @Value(value="${sso.timeout:7200}")
    private int timeout;
    @Value(value="${sso.codeTimeout:600}")
    private int codeTimeout;
    private int accessTokenTimeout;
    @Value(value="${sso.storageStrategy:local}")
    private String storageStrategy;
    private List<AppClient> clients = new ArrayList();
    public Map<String, AppClient> clientMap = new ConcurrentHashMap();

    @PostConstruct
    private void post() {
        if (this.accessTokenTimeout == 0) {
            this.accessTokenTimeout = this.timeout / 2;
        }
        if (this.accessTokenTimeout >= this.timeout) {
            throw new IllegalStateException("accessTokenTimeout\u5fc5\u987b\u5c0f\u4e8etimeout\uff0c \u5426\u5219\u4e0d\u80fd\u53ca\u65f6\u5237\u65b0\u66f4\u6362token");
        }
        this.clientMap.putAll(this.clients.stream().collect(Collectors.toMap(AppClient::getId, c -> c)));
    }

    public String getLogoutUrl(String appId) {
        return this.clients.stream().filter(c -> StringUtils.equals((CharSequence)c.getId(), (CharSequence)appId)).findFirst().orElse(new AppClient()).getLogoutUrl();
    }

    public String toString() {
        return "SsoConfiguration{timeout=" + this.timeout + ", codeTimeout=" + this.codeTimeout + ", accessTokenTimeout=" + this.accessTokenTimeout + ", storageStrategy='" + this.storageStrategy + '\'' + ", clients=" + this.clients + '}';
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getCodeTimeout() {
        return this.codeTimeout;
    }

    public void setCodeTimeout(int codeTimeout) {
        this.codeTimeout = codeTimeout;
    }

    public int getAccessTokenTimeout() {
        return this.accessTokenTimeout;
    }

    public void setAccessTokenTimeout(int accessTokenTimeout) {
        this.accessTokenTimeout = accessTokenTimeout;
    }

    public String getStorageStrategy() {
        return this.storageStrategy;
    }

    public void setStorageStrategy(String storageStrategy) {
        this.storageStrategy = storageStrategy;
    }

    public List<AppClient> getClients() {
        return this.clients;
    }

    public void setClients(List<AppClient> clients) {
        this.clients = clients;
    }

    public Map<String, AppClient> getClientMap() {
        return this.clientMap;
    }

    public void setClientMap(Map<String, AppClient> clientMap) {
        this.clientMap = clientMap;
    }
}

