/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.generator.service;

import cn.xuqiudong.common.base.lookup.Lookup;
import cn.xuqiudong.common.base.model.PageInfo;
import cn.xuqiudong.generator.autoconfigure.GeneratorProperties;
import cn.xuqiudong.generator.dao.BaseGeneratorDao;
import cn.xuqiudong.generator.model.ColumnConfigVO;
import cn.xuqiudong.generator.model.ColumnEntity;
import cn.xuqiudong.generator.model.TableConfigVO;
import cn.xuqiudong.generator.model.TableEntity;
import cn.xuqiudong.generator.tool.DataBaseLikeJointTool;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorService {
    private static final Logger logger = LoggerFactory.getLogger(GeneratorService.class);
    BaseGeneratorDao generatorDao;
    private GeneratorProperties generatorProperties;
    private static final String DEFAULT_JAVA_TYPE = "unknownType";
    static String UNDERLINE = "_";
    static String IGNORE_COLUMN_PREFIX = "is_";

    public GeneratorService(BaseGeneratorDao generatorDao, GeneratorProperties generatorProperties) {
        this.generatorDao = generatorDao;
        this.generatorProperties = generatorProperties;
    }

    public GeneratorService() {
    }

    public PageInfo<TableEntity> list(TableEntity lookup) {
        int total = this.generatorDao.countList(lookup);
        List<TableEntity> list = this.generatorDao.queryList(lookup);
        return new PageInfo(total, list, (Lookup)lookup);
    }

    public TableEntity buildTableDetail(String tableName) {
        TableEntity table = this.generatorDao.queryTable(tableName);
        if (table == null) {
            throw new RuntimeException("\u4e0d\u5b58\u5728\u7684\u8868\u4fe1\u606f");
        }
        List<ColumnEntity> columns = this.generatorDao.queryColumns(tableName);
        boolean hasBigDecimal = false;
        String className = this.tableToJava(table.getTableName(), this.generatorProperties.getTablePrefix());
        table.setClassName(className);
        table.setClassname(StringUtils.uncapitalize((String)className));
        Set<String> ignoreColumns = this.generatorProperties.getIgnores();
        ArrayList<ColumnEntity> unknownJavaTypeList = new ArrayList<ColumnEntity>();
        for (ColumnEntity column : columns) {
            boolean isPk;
            String columnName = column.getColumnName().toLowerCase();
            String attrName = GeneratorService.columnToJava(columnName);
            column.setAttrName(attrName);
            column.setAttrname(StringUtils.uncapitalize((String)attrName));
            String attrType = this.generatorProperties.getDataTypeConvert().getOrDefault(column.getDataType().toLowerCase(), DEFAULT_JAVA_TYPE);
            column.setAttrType(attrType);
            if (DEFAULT_JAVA_TYPE.equals(attrType)) {
                unknownJavaTypeList.add(column);
            }
            if (!hasBigDecimal && "BigDecimal".equals(attrType)) {
                hasBigDecimal = true;
            }
            if ("Date".equals(attrType)) {
                table.setHasDate(true);
            }
            if (ignoreColumns.contains(columnName)) {
                column.setEntityIgnore(true);
            }
            if (!(isPk = column.isPrimaryKey()) || table.getPk() != null) continue;
            table.setPk(column);
        }
        GeneratorService.printUnknownJavaType(unknownJavaTypeList);
        table.setColumns(columns);
        if (table.getPk() == null) {
            table.setPk(columns.get(0));
        }
        return table;
    }

    private static void printUnknownJavaType(List<ColumnEntity> UnknownJavaTypeList) {
        if (CollectionUtils.isEmpty(UnknownJavaTypeList)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        UnknownJavaTypeList.forEach(c -> sb.append("\t").append(c.getColumnName()).append("  -->  ").append(c.getDataType()));
        logger.warn("\u6ca1\u6709\u4e3a\u6570\u636e\u5e93\u7c7b\u578b\u914d\u7f6e\u5bf9\u5e94\u7684java\u7c7b\u578b\u6709:\n{}", (Object)sb);
    }

    private String tableToJava(String tableName, String tablePrefix) {
        if (StringUtils.isNotBlank((CharSequence)tablePrefix)) {
            tableName = GeneratorService.ignoreCaseStartCut(tableName, tablePrefix);
        }
        return GeneratorService.columnToJava(tableName);
    }

    private static String ignoreCaseStartCut(String source, String start) {
        if (StringUtils.startsWithIgnoreCase((CharSequence)source, (CharSequence)start)) {
            return source.substring(start.length());
        }
        return source;
    }

    public static String columnToJava(String columnName) {
        return GeneratorService.underlineToCamel(columnName);
    }

    public static String underlineToCamel(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        int prefixLen = IGNORE_COLUMN_PREFIX.length();
        if (str.length() > prefixLen && str.substring(0, prefixLen).equalsIgnoreCase(IGNORE_COLUMN_PREFIX)) {
            str = str.substring(prefixLen);
        }
        str = str.toLowerCase();
        StringBuilder sb = new StringBuilder();
        for (String s : str.split(UNDERLINE)) {
            sb.append(StringUtils.capitalize((String)s));
        }
        return sb.toString();
    }

    public byte[] exportTables(String[] tableNames, String packageName, String moduleName) {
        if (tableNames == null || tableNames.length == 0) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(outputStream);
        for (String tableName : tableNames) {
            this.generatorCode(new TableConfigVO(tableName, packageName, moduleName), zip);
        }
        IOUtils.closeQuietly((OutputStream)zip);
        return outputStream.toByteArray();
    }

    public byte[] exportByConfig(TableConfigVO tableConfigVO) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(outputStream);
        this.generatorCode(tableConfigVO, zip);
        IOUtils.closeQuietly((OutputStream)zip);
        return outputStream.toByteArray();
    }

    private void generatorCode(TableConfigVO tableConfigVO, ZipOutputStream zip) {
        TableEntity table = this.buildTableDetail(tableConfigVO.getTableName());
        Map<String, Object> map = this.getTemplateData(table, tableConfigVO);
        VelocityContext context = new VelocityContext(map);
        List<String> templates = this.generatorProperties.getTemplates();
        for (String template : templates) {
            StringWriter sw = new StringWriter();
            Template tpl = Velocity.getTemplate((String)template, (String)"UTF-8");
            tpl.merge((Context)context, (Writer)sw);
            try {
                String fileName = GeneratorService.getFileName(template, table.getClassName(), tableConfigVO.getPackageName(), tableConfigVO.getModuleName());
                zip.putNextEntry(new ZipEntry(fileName));
                IOUtils.write((String)sw.toString(), (OutputStream)zip, (String)"UTF-8");
                IOUtils.closeQuietly((Writer)sw);
                zip.closeEntry();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("\u6e32\u67d3\u6a21\u677f\u5931\u8d25\uff0c\u8868\u540d\uff1a" + table.getTableName(), e);
            }
        }
    }

    private Map<String, Object> getTemplateData(TableEntity table, TableConfigVO tableConfigVO) {
        String packageName = tableConfigVO.getPackageName();
        String moduleName = tableConfigVO.getModuleName();
        Properties prop = new Properties();
        prop.put("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        prop.setProperty("userdirective", DataBaseLikeJointTool.class.getName());
        Velocity.init((Properties)prop);
        this.configColumn(table, tableConfigVO);
        HashMap<String, Object> map = new HashMap<String, Object>(32);
        map.put("table", (Object)table);
        map.put("tableName", table.getTableName());
        map.put("comments", table.getComments());
        map.put("pk", table.getPk());
        map.put("className", table.getClassName());
        map.put("classname", table.getClassname());
        map.put("pathName", table.getClassname().toLowerCase());
        map.put("columns", table.getColumns());
        map.put("listColumns", table.getListColumns());
        map.put("hasBigDecimal", table.getHasBigDecimal());
        map.put("package", packageName);
        map.put("moduleName", moduleName);
        map.put("author", this.generatorProperties.getAuthor());
        map.put("dialect", this.generatorProperties.getTaDatabaseType().getDialect());
        map.put("datetime", DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm"));
        return map;
    }

    public static String getFileName(String template, String className, String packageName, String moduleName) {
        String packagePath = (packageName + File.separator + moduleName).replace(".", File.separator);
        String entityName = "Entity.java";
        String filename = template.substring(0, template.length() - 3).substring(template.lastIndexOf("/") + 1);
        String type = filename.substring(0, filename.indexOf("."));
        if (entityName.equals(filename)) {
            filename = ".java";
            type = "model";
        }
        filename = packagePath.toLowerCase() + File.separator + type.toLowerCase() + File.separator + className + filename;
        return filename;
    }

    private void configColumn(TableEntity table, TableConfigVO tableConfigVO) {
        if (table == null || tableConfigVO == null || table.getColumns() == null) {
            return;
        }
        List<ColumnEntity> columns = table.getColumns();
        Set<String> ignoreColumns = this.generatorProperties.getIgnores();
        List<ColumnConfigVO> columnsConfig = tableConfigVO.getColumns();
        HashMap<String, ColumnConfigVO> columnsConfigMap = new HashMap<String, ColumnConfigVO>(32);
        if (columnsConfig != null) {
            for (ColumnConfigVO co : columnsConfig) {
                columnsConfigMap.put(co.getColumnName(), co);
            }
            for (ColumnEntity c2 : columns) {
                ColumnConfigVO config = (ColumnConfigVO)columnsConfigMap.get(c2.getColumnName());
                if (config != null) {
                    c2.getExtend().setShow(config.getShow()).setWhere(config.getShow()).setCondition(config.getCondition());
                }
                if (!ignoreColumns.contains(c2.getColumnName().toLowerCase())) continue;
                c2.getExtend().setShow(true);
            }
        } else {
            Set<String> textTypes = this.generatorProperties.getTextTypes();
            columns.forEach(c -> {
                String dateType = c.getDataType();
                boolean show = !textTypes.contains(dateType);
                int condition = "String".equalsIgnoreCase(c.getAttrType()) ? 1 : 0;
                c.getExtend().setShow(show).setWhere(show).setCondition(condition);
            });
        }
    }
}

