/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.generator.dao;

import cn.xuqiudong.generator.contant.DatabaseType;
import cn.xuqiudong.generator.dao.BaseGeneratorDao;
import cn.xuqiudong.generator.model.ColumnEntity;
import cn.xuqiudong.generator.model.TableEntity;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class MysqlGeneratorDao
extends BaseGeneratorDao {
    public MysqlGeneratorDao(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public int countList(TableEntity lookup) {
        StringBuffer sql = new StringBuffer("SELECT count(*) FROM information_schema.tables \t\tWHERE table_schema = (select database())");
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append(this.buildListWhere(lookup, params));
        return (Integer)this.jdbcTemplate.queryForObject(sql.toString(), params.toArray(new Object[0]), Integer.class);
    }

    private String buildListWhere(TableEntity lookup, List<Object> params) {
        StringBuffer sql = new StringBuffer();
        if (StringUtils.isNotBlank((CharSequence)lookup.getTableName())) {
            sql.append(" and table_name like concat('%', ?, '%') ");
            params.add(lookup.getTableName());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{lookup.getComments()})) {
            sql.append(" and table_comment like concat('%',?, '%') ");
            params.add(lookup.getComments());
        }
        if (StringUtils.isNotBlank((CharSequence)lookup.getEngine())) {
            sql.append(" and engine = ? ");
            params.add(lookup.getEngine());
        }
        return sql.toString();
    }

    @Override
    public List<TableEntity> queryList(TableEntity lookup) {
        StringBuffer sql = new StringBuffer("SELECT table_name tableName, engine, table_comment comments, create_time createTime \t\tFROM information_schema.tables \t\tWHERE table_schema = (select database())");
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append(this.buildListWhere(lookup, params));
        if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{lookup.getSortColumn(), lookup.getSortOrder()})) {
            sql.append(" order by ? ? ");
            params.add(lookup.getSortColumn());
            params.add(lookup.getSortOrder());
        } else {
            sql.append(" order by create_time desc ");
        }
        sql.append(" LIMIT ").append(lookup.getIndex()).append(", ").append(lookup.getSize());
        return this.jdbcTemplate.query(sql.toString(), (RowMapper)new BeanPropertyRowMapper(TableEntity.class), params.toArray(new Object[0]));
    }

    @Override
    public List<ColumnEntity> queryColumns(String tableName) {
        String sql = "SELECT column_name columnName, data_type dataType, column_comment comments, column_key columnKey, extra \n\t\tFROM information_schema.columns\n \t\tWHERE table_name = ? and table_schema = (select database()) order by ordinal_position";
        return this.jdbcTemplate.query(sql.toString(), (RowMapper)new BeanPropertyRowMapper(ColumnEntity.class), new Object[]{tableName});
    }

    @Override
    public TableEntity queryTable(String tableName) {
        String sql = "select table_name tableName, engine, table_comment comments, create_time createTime from information_schema.tables \n\t\t\twhere table_schema = (select database()) and table_name = ?";
        return (TableEntity)((Object)this.jdbcTemplate.queryForObject(sql, (RowMapper)new BeanPropertyRowMapper(TableEntity.class), new Object[]{tableName}));
    }

    @Override
    public DatabaseType databaseType() {
        return DatabaseType.mysql;
    }
}

