/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.generator.dao;

import cn.xuqiudong.common.util.sql.SqlUtil;
import cn.xuqiudong.generator.contant.DatabaseType;
import cn.xuqiudong.generator.dao.BaseGeneratorDao;
import cn.xuqiudong.generator.model.ColumnEntity;
import cn.xuqiudong.generator.model.TableEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class GaussGeneratorDao
extends BaseGeneratorDao {
    String from = " FROM pg_class a JOIN pg_namespace b ON a.relnamespace = b.oid  LEFT JOIN pg_description c ON a.oid = c.objoid AND c.objsubid = '0'  LEFT JOIN pg_tables d on d.tablename = a.relname  WHERE a.relkind = 'r' and b.nspname =  current_schema ";
    Set<String> sortableColumns = Stream.of("tableName", "comments", "createTime").collect(Collectors.toSet());

    public GaussGeneratorDao(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public DatabaseType databaseType() {
        return DatabaseType.gauss;
    }

    @Override
    public List<TableEntity> queryList(TableEntity lookup) {
        StringBuffer sql = new StringBuffer("SELECT a.relname AS tableName, c.description AS comments,d.created AS createTime ");
        sql.append(this.from);
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append(this.buildListWhere(lookup, params));
        if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{lookup.getSortColumn(), lookup.getSortOrder()}) && this.sortableColumns.contains(lookup.getSortColumn())) {
            sql.append(" order by ? ? ");
            params.add(lookup.getSortColumn());
            params.add(lookup.getSortOrder());
        } else {
            sql.append(" order by d.created DESC ");
        }
        String pageSql = SqlUtil.oracleLimit((String)sql.toString(), (int)lookup.getPage(), (int)lookup.getSize());
        return this.jdbcTemplate.query(pageSql, (RowMapper)new BeanPropertyRowMapper(TableEntity.class), params.toArray(new Object[0]));
    }

    private String buildListWhere(TableEntity lookup, List<Object> params) {
        StringBuilder sql = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)lookup.getTableName())) {
            sql.append(" and a.relname like ? ");
            params.add("%" + lookup.getTableName().toUpperCase() + "%");
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{lookup.getComments()})) {
            sql.append(" and c.description like ? ");
            params.add("%" + lookup.getComments().toUpperCase() + "%");
        }
        return sql.toString();
    }

    @Override
    public int countList(TableEntity lookup) {
        StringBuffer sql = new StringBuffer("SELECT count(*) ").append(this.from);
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append(this.buildListWhere(lookup, params));
        Object[] args = params.toArray(new Object[0]);
        Integer count = (Integer)this.jdbcTemplate.queryForObject(sql.toString(), Integer.class, args);
        return count == null ? 0 : count;
    }

    @Override
    public List<ColumnEntity> queryColumns(String tableName) {
        String sql = "SELECT  a.attname AS columnName, t.typname AS dataType, col_description(a.attrelid, a.attnum) AS \"comments\",  c.contype AS constraint_type FROM   pg_attribute a JOIN     pg_type t ON a.atttypid = t.oid LEFT JOIN  pg_constraint c ON a.attrelid = c.conrelid AND a.attnum = ANY (c.conkey) WHERE a.attrelid = (SELECT oid FROM pg_class WHERE relname = ?) AND a.attnum > 0";
        return this.jdbcTemplate.query(sql.toString(), (RowMapper)new BeanPropertyRowMapper(ColumnEntity.class), new Object[]{tableName});
    }

    @Override
    public TableEntity queryTable(String tableName) {
        String sql = "SELECT a.relname AS tableName, c.description AS comments,d.created AS createTime " + this.from + "and a.relname = ?";
        return (TableEntity)((Object)this.jdbcTemplate.queryForObject(sql, (RowMapper)new BeanPropertyRowMapper(TableEntity.class), new Object[]{tableName}));
    }
}

