/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.generator.dao;

import cn.xuqiudong.common.util.sql.SqlUtil;
import cn.xuqiudong.generator.contant.DatabaseType;
import cn.xuqiudong.generator.dao.BaseGeneratorDao;
import cn.xuqiudong.generator.model.ColumnEntity;
import cn.xuqiudong.generator.model.TableEntity;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class OracleGeneratorDao
extends BaseGeneratorDao {
    public OracleGeneratorDao(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public int countList(TableEntity lookup) {
        StringBuffer sql = new StringBuffer("SELECT count(*) from user_tables a  left join user_tab_comments b on a.TABLE_NAME = b.table_name   left join user_objects c on a.TABLE_NAME = c.object_name and c.OBJECT_TYPE = 'TABLE'  where a.TABLESPACE_NAME   is not null");
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append(this.buildListWhere(lookup, params));
        Object[] args = params.toArray(new Object[0]);
        Integer count = (Integer)this.jdbcTemplate.queryForObject(sql.toString(), Integer.class, args);
        return count == null ? 0 : count;
    }

    private String buildListWhere(TableEntity lookup, List<Object> params) {
        StringBuffer sql = new StringBuffer();
        if (StringUtils.isNotBlank((CharSequence)lookup.getTableName())) {
            sql.append(" and a.table_name like ? ");
            params.add("%" + lookup.getTableName().toUpperCase() + "%");
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{lookup.getComments()})) {
            sql.append(" and b.comments like ? ");
            params.add("%" + lookup.getComments().toUpperCase() + "%");
        }
        return sql.toString();
    }

    @Override
    public List<TableEntity> queryList(TableEntity lookup) {
        StringBuffer sql = new StringBuffer("SELECT a.table_name as tableName, b.comments, 'none' as engine ,c.created as createTime      FROM user_tables a  left join user_tab_comments b on a.TABLE_NAME = b.table_name   left join user_objects c on a.table_name = c.object_name and c.object_type = 'TABLE'  where a.tablespace_name   is not null ");
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append(this.buildListWhere(lookup, params));
        if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{lookup.getSortColumn(), lookup.getSortOrder()})) {
            sql.append(" order by ? ? ");
            params.add(lookup.getSortColumn());
            params.add(lookup.getSortOrder());
        } else {
            sql.append(" order by a.table_name ");
        }
        String pageSql = SqlUtil.oracleLimit((String)sql.toString(), (int)lookup.getPage(), (int)lookup.getSize());
        return this.jdbcTemplate.query(pageSql, (RowMapper)new BeanPropertyRowMapper(TableEntity.class), params.toArray(new Object[0]));
    }

    @Override
    public List<ColumnEntity> queryColumns(String tableName) {
        String sql = "   select a.column_name as  columnName, a.data_type as dataType, b.comments ,d.constraint_type as columnKey FROM user_tab_columns a left join user_col_comments  b on a.table_name = b.table_name and a.column_name = b.column_name  LEFT JOIN user_cons_columns c on a.TABLE_NAME = c.table_name and c.column_name = a.COLUMN_NAME  LEFT JOIN  user_constraints d on c.constraint_name = d.constraint_name WHERE a.table_name = ? order by a.column_id";
        List list = this.jdbcTemplate.query(sql.toString(), (RowMapper)new BeanPropertyRowMapper(ColumnEntity.class), new Object[]{tableName});
        Map group = list.stream().collect(Collectors.groupingBy(ColumnEntity::getColumnName, LinkedHashMap::new, Collectors.toList()));
        ArrayList<ColumnEntity> result = new ArrayList<ColumnEntity>();
        group.forEach((k, v) -> {
            for (ColumnEntity c : v) {
                if (!c.isPrimaryKey()) continue;
                result.add(c);
                return;
            }
            result.add((ColumnEntity)v.get(0));
        });
        return result;
    }

    @Override
    public TableEntity queryTable(String tableName) {
        String sql = "SELECT a.table_name as tableName, b.comments, 'none' as engine ,c.created as createTime      FROM user_tables a  left join user_tab_comments b on a.TABLE_NAME = b.table_name   left join user_objects c on a.table_name = c.object_name and c.object_type = 'TABLE'          where a.table_name = ?";
        return (TableEntity)((Object)this.jdbcTemplate.queryForObject(sql, (RowMapper)new BeanPropertyRowMapper(TableEntity.class), new Object[]{tableName}));
    }

    @Override
    public DatabaseType databaseType() {
        return DatabaseType.oracle;
    }
}

