/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.generator.controller;

import cn.xuqiudong.common.base.model.BaseResponse;
import cn.xuqiudong.common.base.model.PageInfo;
import cn.xuqiudong.generator.model.TableConfigVO;
import cn.xuqiudong.generator.model.TableEntity;
import cn.xuqiudong.generator.service.GeneratorService;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Resource;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/generator"})
public class GeneratorController {
    @Resource
    private GeneratorService generatorService;

    public GeneratorController() {
    }

    public GeneratorController(GeneratorService generatorService) {
        this.generatorService = generatorService;
    }

    @GetMapping(value={"", "/"})
    public void home(HttpServletResponse response, HttpServletRequest request) throws Exception {
        String url = "generator.html";
        request.getRequestDispatcher(url).forward((ServletRequest)request, (ServletResponse)response);
    }

    @ResponseBody
    @GetMapping(value={"/list"})
    public BaseResponse<?> list(TableEntity lookup) {
        PageInfo<TableEntity> data = this.generatorService.list(lookup);
        return BaseResponse.success(data);
    }

    @ResponseBody
    @GetMapping(value={"/table/detail"})
    public BaseResponse<?> table(@RequestParam(value="id") String tableName) {
        TableEntity data = this.generatorService.buildTableDetail(tableName);
        return BaseResponse.success((Object)((Object)data));
    }

    @ResponseBody
    @RequestMapping(value={"/exportByConfig"}, method={RequestMethod.POST, RequestMethod.GET})
    public void exportByConfig(TableConfigVO tableConfigVO, HttpServletResponse response) throws IOException {
        byte[] data = this.generatorService.exportByConfig(tableConfigVO);
        this.download(data, response);
    }

    @ResponseBody
    @RequestMapping(value={"/exportTables"}, method={RequestMethod.POST, RequestMethod.GET})
    public void exportTables(String[] tableName, @RequestParam(defaultValue="") String packageName, @RequestParam(defaultValue="") String moduleName, HttpServletResponse response) throws IOException {
        byte[] data = this.generatorService.exportTables(tableName, packageName, moduleName);
        this.download(data, response);
    }

    private void download(byte[] data, HttpServletResponse response) throws IOException {
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"generator-vic.zip\"");
        response.addHeader("Content-Length", "" + data.length);
        response.setContentType("application/octet-stream; charset=UTF-8");
        IOUtils.write((byte[])data, (OutputStream)response.getOutputStream());
    }
}

