/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.generator.autoconfigure;

import cn.xuqiudong.generator.contant.DatabaseType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@ConfigurationProperties(prefix="generator")
@PropertySource(value={"classpath:config/generator-config.properties"})
public class GeneratorProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR_PREFIX = "generator";
    @Value(value="${generator.database:mysql}")
    private String database;
    private String author;
    private String tablePrefix;
    private Set<String> ignores;
    private Set<String> textTypes;
    private List<String> templates;
    private Map<String, String> dataTypeConvert;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="\u662f\u53ef\u53d8\u7684")
    public static Map<String, String> DEFAULT_DATA_TYPE_CONVERT = new HashMap<String, String>();

    @PostConstruct
    private void post() {
        this.mergerDataType();
        this.ignorestoLowerCase();
    }

    private void ignorestoLowerCase() {
        if (this.ignores == null) {
            this.ignores = new HashSet<String>();
            return;
        }
        HashSet<String> set = new HashSet<String>();
        this.ignores.forEach(i -> set.add(i.toLowerCase()));
        this.ignores = set;
    }

    private void mergerDataType() {
        if (this.dataTypeConvert == null || this.dataTypeConvert.isEmpty()) {
            this.dataTypeConvert = new HashMap<String, String>();
            this.dataTypeConvert.putAll(DEFAULT_DATA_TYPE_CONVERT);
            return;
        }
        this.dataTypeConvert.forEach((k, v) -> this.dataTypeConvert.put(k.toLowerCase(), (String)v));
        DEFAULT_DATA_TYPE_CONVERT.forEach((k, v) -> {
            if (!this.dataTypeConvert.containsKey(k)) {
                this.dataTypeConvert.put((String)k, (String)v);
            }
        });
    }

    public String toString() {
        ArrayList dataTypeConverts = new ArrayList();
        this.dataTypeConvert.forEach((k, v) -> dataTypeConverts.add(k + "=" + v));
        String sb = "\t\u3010database=" + this.database + ", author=" + this.author + ", tablePrefix=" + this.tablePrefix + ",\n\t ignores=[" + this.ignores + "],\n\t textTypes=[" + String.join((CharSequence)";", this.textTypes) + "],\n\t templates=[\n\t\t" + String.join((CharSequence)"\n\t\t", this.templates) + "],\n\t  dataTypeConvert=[" + String.join((CharSequence)";", dataTypeConverts) + "]\n\t\u3011";
        return sb;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public Set<String> getIgnores() {
        return this.ignores;
    }

    public List<String> getTemplates() {
        return this.templates;
    }

    public Map<String, String> getDataTypeConvert() {
        return this.dataTypeConvert;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public void setIgnores(Set<String> ignores) {
        this.ignores = ignores;
    }

    public void setTemplates(List<String> templates) {
        this.templates = templates;
    }

    public void setDataTypeConvert(Map<String, String> dataTypeConvert) {
        this.dataTypeConvert = dataTypeConvert;
    }

    public String getDatabase() {
        return this.database;
    }

    public DatabaseType getTaDatabaseType() {
        return DatabaseType.getByName(this.database);
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public Set<String> getTextTypes() {
        return this.textTypes;
    }

    public void setTextTypes(Set<String> textTypes) {
        this.textTypes = textTypes;
    }

    static {
        DEFAULT_DATA_TYPE_CONVERT.put("tinyint", "Integer");
        DEFAULT_DATA_TYPE_CONVERT.put("smallint", "Integer");
        DEFAULT_DATA_TYPE_CONVERT.put("mediumint", "Integer");
        DEFAULT_DATA_TYPE_CONVERT.put("int", "Integer");
        DEFAULT_DATA_TYPE_CONVERT.put("integer", "Integer");
        DEFAULT_DATA_TYPE_CONVERT.put("number", "Integer");
        DEFAULT_DATA_TYPE_CONVERT.put("bigint", "Long");
        DEFAULT_DATA_TYPE_CONVERT.put("float", "Float");
        DEFAULT_DATA_TYPE_CONVERT.put("double", "Double");
        DEFAULT_DATA_TYPE_CONVERT.put("decimal", "BigDecimal");
        DEFAULT_DATA_TYPE_CONVERT.put("bit", "BigDecimal");
        DEFAULT_DATA_TYPE_CONVERT.put("enum", "String");
        DEFAULT_DATA_TYPE_CONVERT.put("char", "String");
        DEFAULT_DATA_TYPE_CONVERT.put("varchar", "String");
        DEFAULT_DATA_TYPE_CONVERT.put("varchar2", "String");
        DEFAULT_DATA_TYPE_CONVERT.put("tinytext", "String");
        DEFAULT_DATA_TYPE_CONVERT.put("mediumtext", "String");
        DEFAULT_DATA_TYPE_CONVERT.put("longtext", "String");
        DEFAULT_DATA_TYPE_CONVERT.put("blob", "String");
        DEFAULT_DATA_TYPE_CONVERT.put("clob", "String");
        DEFAULT_DATA_TYPE_CONVERT.put("date", "Date");
        DEFAULT_DATA_TYPE_CONVERT.put("time", "Date");
        DEFAULT_DATA_TYPE_CONVERT.put("datetime", "Date");
        DEFAULT_DATA_TYPE_CONVERT.put("timestamp", "Date");
        DEFAULT_DATA_TYPE_CONVERT.put("timestamp(6)", "Date");
    }
}

