/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.generator.autoconfigure;

import cn.xuqiudong.generator.autoconfigure.GeneratorProperties;
import cn.xuqiudong.generator.contant.DatabaseType;
import cn.xuqiudong.generator.controller.GeneratorController;
import cn.xuqiudong.generator.dao.BaseGeneratorDao;
import cn.xuqiudong.generator.dao.MysqlGeneratorDao;
import cn.xuqiudong.generator.dao.OracleGeneratorDao;
import cn.xuqiudong.generator.helper.ShowAccessUrlHelper;
import cn.xuqiudong.generator.service.GeneratorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.Assert;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnClass(value={JdbcTemplate.class})
@ConditionalOnWebApplication
@ConditionalOnExpression(value="${generatir.enabled:true}")
@EnableConfigurationProperties(value={GeneratorProperties.class})
public class GeneratorAutoConfiguration {
    private static Logger logger = LoggerFactory.getLogger(GeneratorAutoConfiguration.class);
    private GeneratorProperties generatorProperties;
    private JdbcTemplate jdbcTemplate;

    public GeneratorAutoConfiguration(GeneratorProperties generatorProperties, JdbcTemplate jdbcTemplate) {
        this.generatorProperties = generatorProperties;
        this.jdbcTemplate = jdbcTemplate;
    }

    @Bean
    @ConditionalOnMissingBean
    public BaseGeneratorDao generatorDao() {
        DatabaseType type = DatabaseType.getByName(this.generatorProperties.getDatabase());
        Assert.notNull((Object)((Object)type), (String)("\u5f53\u524d\u9879\u76ee\u672a\u652f\u6301" + (Object)((Object)type) + "\u7c7b\u578b\u7684\u6570\u636e\u5e93\u4ee3\u7801\u751f\u6210\u3002"));
        Object generatorDao = null;
        switch (type) {
            case oracle: {
                generatorDao = new OracleGeneratorDao(this.jdbcTemplate);
                break;
            }
            case mysql: {
                generatorDao = new MysqlGeneratorDao(this.jdbcTemplate);
            }
        }
        logger.info("\u4ee3\u7801\u81ea\u52a8\u751f\u6210\u5f53\u524d\u914d\u7f6e\u7684\u6570\u636e\u5e93\u7c7b\u578b\u4e3a\uff1a{}, \u4f7f\u7528\u7684dao\u4e3a{}\u3002", (Object)type, (Object)generatorDao.getClass().getSimpleName());
        logger.info("\u4ee3\u7801\u81ea\u52a8\u751f\u6210\u76f8\u5173\u914d\u7f6e\u5982\u4e0b\uff1a\n{}", (Object)this.generatorProperties);
        return generatorDao;
    }

    @Bean
    @ConditionalOnMissingBean
    public GeneratorService generatorService(BaseGeneratorDao generatorDao, GeneratorProperties generatorProperties) {
        return new GeneratorService(generatorDao, generatorProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public GeneratorController generatorController(GeneratorService generatorService) {
        return new GeneratorController(generatorService);
    }

    @Bean
    @ConditionalOnMissingBean
    public ShowAccessUrlHelper showAccessUrlHelper() {
        return new ShowAccessUrlHelper();
    }

    @Configuration
    static class StaticWebMvcConfigurerAdapter
    implements WebMvcConfigurer {
        StaticWebMvcConfigurerAdapter() {
        }

        public void addResourceHandlers(ResourceHandlerRegistry registry) {
        }
    }
}

