/*
 * Decompiled with CFR 0.152.
 */
package cn.xuanyuanli.playwright.stealth.pool;

import cn.xuanyuanli.playwright.stealth.config.PlaywrightConfig;
import cn.xuanyuanli.playwright.stealth.manager.PlaywrightManager;
import com.microsoft.playwright.Browser;
import com.microsoft.playwright.Playwright;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaywrightBrowserFactory
extends BasePooledObjectFactory<Browser> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlaywrightBrowserFactory.class);
    private final PlaywrightConfig config;
    private static final ConcurrentMap<Browser, Playwright> PLAYWRIGHT_CACHE = new ConcurrentHashMap<Browser, Playwright>();

    public PlaywrightBrowserFactory(PlaywrightConfig config) {
        this.config = config != null ? config : new PlaywrightConfig();
        log.debug("PlaywrightBrowserFactory created with config: {}", (Object)this.config);
    }

    public Browser create() {
        try {
            Playwright playwright = Playwright.create();
            Browser browser = PlaywrightManager.createBrowser(this.config, playwright);
            PLAYWRIGHT_CACHE.put(browser, playwright);
            log.debug("Browser created successfully with config: {}", (Object)this.config);
            return browser;
        }
        catch (Exception e) {
            log.error("Failed to create browser instance", (Throwable)e);
            throw new RuntimeException("Browser creation failed", e);
        }
    }

    public PooledObject<Browser> wrap(Browser browser) {
        return new DefaultPooledObject((Object)browser);
    }

    public boolean validateObject(PooledObject<Browser> pooledBrowser) {
        Browser browser = (Browser)pooledBrowser.getObject();
        try {
            browser.contexts();
            return true;
        }
        catch (Exception e) {
            log.warn("Browser validation failed, will be destroyed and recreated", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyObject(PooledObject<Browser> pooledBrowser) {
        Browser browser = (Browser)pooledBrowser.getObject();
        Playwright playwright = null;
        try {
            playwright = (Playwright)PLAYWRIGHT_CACHE.get(browser);
            if (playwright != null) {
                playwright.close();
                log.debug("Playwright instance closed successfully");
            }
        }
        catch (Exception e) {
            log.warn("Error closing Playwright instance", (Throwable)e);
        }
        finally {
            if (browser != null) {
                PLAYWRIGHT_CACHE.remove(browser);
            }
            try {
                if (browser != null && browser.isConnected()) {
                    browser.close();
                }
            }
            catch (Exception e) {
                log.warn("Error closing Browser instance", (Throwable)e);
            }
        }
        log.debug("Browser destroyed successfully. Cache size: {}", (Object)PLAYWRIGHT_CACHE.size());
    }
}

