/*
 * Decompiled with CFR 0.152.
 */
package cn.xuanyuanli.playwright.stealth.manager;

import cn.xuanyuanli.playwright.stealth.config.PlaywrightConfig;
import cn.xuanyuanli.playwright.stealth.pool.PlaywrightFactory;
import cn.xuanyuanli.playwright.stealth.stealth.StealthScriptProvider;
import com.microsoft.playwright.Browser;
import com.microsoft.playwright.BrowserContext;
import com.microsoft.playwright.BrowserType;
import com.microsoft.playwright.Page;
import com.microsoft.playwright.Playwright;
import java.util.ArrayList;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaywrightManager
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlaywrightManager.class);
    private final GenericObjectPool<Playwright> pool;

    public PlaywrightManager(int capacity) {
        this(null, capacity);
    }

    public PlaywrightManager(GenericObjectPoolConfig<Playwright> poolConfig, int capacity) {
        if (poolConfig == null) {
            poolConfig = new GenericObjectPoolConfig();
            poolConfig.setMaxTotal(capacity);
            poolConfig.setMinIdle(1);
            poolConfig.setMaxIdle(capacity);
            poolConfig.setTestOnBorrow(false);
            poolConfig.setTestOnReturn(false);
        }
        this.pool = new GenericObjectPool((PooledObjectFactory)new PlaywrightFactory(), poolConfig);
        log.info("PlaywrightManager initialized with pool capacity: {}", (Object)capacity);
    }

    public void execute(Consumer<Page> pageConsumer) {
        this.execute(null, null, pageConsumer);
    }

    public void execute(PlaywrightConfig config, Consumer<Page> pageConsumer) {
        this.execute(config, null, pageConsumer);
    }

    public void execute(PlaywrightConfig config, Consumer<BrowserContext> browserContextConsumer, Consumer<Page> pageConsumer) {
        if (config == null) {
            config = new PlaywrightConfig();
        }
        Playwright playwright = null;
        try {
            playwright = (Playwright)this.pool.borrowObject();
            this.executeInternal(config, browserContextConsumer, pageConsumer, playwright);
        }
        catch (Exception e) {
            log.error("Failed to execute playwright operation", (Throwable)e);
            throw new RuntimeException("Playwright operation failed", e);
        }
        finally {
            if (playwright != null) {
                try {
                    this.pool.returnObject((Object)playwright);
                }
                catch (Exception e) {
                    log.warn("Failed to return playwright object to pool", (Throwable)e);
                }
            }
        }
    }

    public static void executeWithPlaywright(PlaywrightConfig config, Consumer<BrowserContext> browserContextConsumer, Consumer<Page> pageConsumer, Playwright playwright) {
        if (config == null) {
            config = new PlaywrightConfig();
        }
        try (Browser browser = PlaywrightManager.createBrowser(config, playwright);){
            PlaywrightManager.executeWithBrowser(config, browserContextConsumer, pageConsumer, browser);
        }
    }

    public static void executeWithBrowser(PlaywrightConfig config, Consumer<BrowserContext> browserContextConsumer, Consumer<Page> pageConsumer, Browser browser) {
        if (config == null) {
            config = new PlaywrightConfig();
        }
        BrowserContext browserContext = null;
        Page page = null;
        try {
            browserContext = browser.newContext(config.getNewContextOptions());
            if (browserContextConsumer != null) {
                browserContextConsumer.accept(browserContext);
            }
            page = browserContext.newPage();
            if (config.getStealthMode().isEnabled()) {
                if (config.getStealthMode().isLight()) {
                    page.addInitScript(StealthScriptProvider.getLightStealthScript());
                    log.debug("Light stealth script injected");
                } else if (config.getStealthMode().isFull()) {
                    page.addInitScript(StealthScriptProvider.getStealthScript());
                    log.debug("Full stealth script injected");
                }
            }
            if (config.getCustomInitScripts() != null && !config.getCustomInitScripts().isEmpty()) {
                for (int i = 0; i < config.getCustomInitScripts().size(); ++i) {
                    String script = config.getCustomInitScripts().get(i);
                    page.addInitScript(script);
                    log.debug("Custom init script [{}] injected: {} chars", (Object)(i + 1), (Object)script.length());
                }
                log.debug("Total {} custom init scripts injected", (Object)config.getCustomInitScripts().size());
            }
            pageConsumer.accept(page);
        }
        catch (Exception e) {
            log.error("Page operation failed", (Throwable)e);
            throw new RuntimeException("Page operation failed", e);
        }
        finally {
            if (page != null) {
                try {
                    page.close();
                }
                catch (Exception e) {
                    log.warn("Failed to close page", (Throwable)e);
                }
            }
            if (browserContext != null) {
                try {
                    browserContext.close();
                }
                catch (Exception e) {
                    log.warn("Failed to close browser context", (Throwable)e);
                }
            }
        }
    }

    public static Browser createBrowser(PlaywrightConfig config, Playwright playwright) {
        if (config == null) {
            config = new PlaywrightConfig();
        }
        ArrayList<String> args = new ArrayList<String>();
        if (config.isDisableImageRender()) {
            args.add("--blink-settings=imagesEnabled=false");
        }
        if (config.isDisableAutomationControlled()) {
            args.add("--disable-blink-features=AutomationControlled");
        }
        if (config.isDisableGpu()) {
            args.add("--disable-gpu");
        }
        if (config.isStartMaximized()) {
            args.add("--start-maximized");
        }
        BrowserType.LaunchOptions options = new BrowserType.LaunchOptions().setArgs(args).setHeadless(config.isHeadless()).setChromiumSandbox(config.isChromiumSandbox());
        if (config.getSlowMo() != null) {
            options.setSlowMo(config.getSlowMo().doubleValue());
        }
        if (config.getProxy() != null) {
            options.setProxy(config.getProxy());
        }
        log.debug("Launching browser with config: headless={}, args={}", (Object)config.isHeadless(), args);
        return playwright.chromium().launch(options);
    }

    public String getPoolStatus() {
        return String.format("Pool Status - Active: %d, Idle: %d, Total: %d/%d", this.pool.getNumActive(), this.pool.getNumIdle(), this.pool.getNumActive() + this.pool.getNumIdle(), this.pool.getMaxTotal());
    }

    private void executeInternal(PlaywrightConfig config, Consumer<BrowserContext> browserContextConsumer, Consumer<Page> pageConsumer, Playwright playwright) {
        PlaywrightManager.executeWithPlaywright(config, browserContextConsumer, pageConsumer, playwright);
    }

    @Override
    public void close() {
        try {
            this.pool.close();
            log.info("PlaywrightManager closed successfully");
        }
        catch (Exception e) {
            log.error("Error closing PlaywrightManager", (Throwable)e);
        }
    }
}

