/*
 * Decompiled with CFR 0.152.
 */
package cn.xuanyuanli.playwright.stealth.behavior;

import cn.xuanyuanli.playwright.stealth.behavior.BehaviorIntensity;
import com.microsoft.playwright.Page;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HumanBehaviorSimulator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HumanBehaviorSimulator.class);

    public static void simulate(Page page) {
        HumanBehaviorSimulator.simulate(page, BehaviorIntensity.NORMAL);
    }

    public static void quickSimulate(Page page) {
        HumanBehaviorSimulator.simulate(page, BehaviorIntensity.QUICK);
    }

    public static void simulate(Page page, BehaviorIntensity intensity) {
        if (page == null) {
            log.warn("Page is null, skipping behavior simulation");
            return;
        }
        if (intensity == null) {
            log.warn("BehaviorIntensity is null, using default NORMAL intensity");
            intensity = BehaviorIntensity.NORMAL;
        }
        log.debug("Starting behavior simulation with intensity: {}", (Object)intensity);
        long startTime = System.currentTimeMillis();
        long targetDuration = ThreadLocalRandom.current().nextLong(intensity.getMinDurationMs(), intensity.getMaxDurationMs() + 1);
        long endTime = startTime + targetDuration;
        try {
            HumanBehaviorSimulator.executeTimeDrivenBehavior(page, endTime, intensity);
            long actualDuration = System.currentTimeMillis() - startTime;
            log.debug("Behavior simulation completed in {}ms (target: {}ms) with intensity: {}", new Object[]{actualDuration, targetDuration, intensity});
        }
        catch (Exception e) {
            log.error("Failed to execute behavior simulation with intensity: " + String.valueOf((Object)intensity), (Throwable)e);
        }
    }

    private static void executeTimeDrivenBehavior(Page page, long endTime, BehaviorIntensity intensity) {
        long remainingTime;
        PageDimensions dimensions = HumanBehaviorSimulator.getPageDimensions(page);
        log.trace("Page dimensions: {}x{}", (Object)dimensions.width, (Object)dimensions.height);
        int actionCount = 0;
        while (System.currentTimeMillis() < endTime && (remainingTime = endTime - System.currentTimeMillis()) >= 50L) {
            long delay;
            SafeAction action = HumanBehaviorSimulator.getRandomSafeAction();
            HumanBehaviorSimulator.executeAction(page, action, dimensions);
            ++actionCount;
            long remainingAfterAction = endTime - System.currentTimeMillis();
            if (remainingAfterAction <= 0L || (delay = HumanBehaviorSimulator.calculateSmartDelay(remainingAfterAction, intensity)) <= 0L) continue;
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.debug("Behavior simulation interrupted");
                break;
            }
        }
        log.trace("Executed {} actions during behavior simulation", (Object)actionCount);
    }

    private static SafeAction getRandomSafeAction() {
        SafeAction[] actions = SafeAction.values();
        return actions[ThreadLocalRandom.current().nextInt(actions.length)];
    }

    private static void executeAction(Page page, SafeAction action, PageDimensions dimensions) {
        try {
            switch (action.ordinal()) {
                case 0: {
                    HumanBehaviorSimulator.executeRandomMouseMove(page, dimensions);
                    break;
                }
                case 1: {
                    HumanBehaviorSimulator.executeScrollDown(page);
                    break;
                }
                case 2: {
                    HumanBehaviorSimulator.executeScrollUp(page);
                    break;
                }
                case 3: {
                    HumanBehaviorSimulator.executeScrollToRandom(page);
                    break;
                }
                case 4: {
                    HumanBehaviorSimulator.executeSafeHover(page);
                    break;
                }
                case 5: {
                    HumanBehaviorSimulator.executeMouseTrack(page, dimensions);
                    break;
                }
                case 6: {
                    HumanBehaviorSimulator.executeGentleDrag(page, dimensions);
                }
            }
            log.trace("Executed action: {}", (Object)action);
        }
        catch (Exception e) {
            log.trace("Action {} failed: {}", (Object)action, (Object)e.getMessage());
        }
    }

    private static void executeRandomMouseMove(Page page, PageDimensions dimensions) {
        double x = ThreadLocalRandom.current().nextDouble(50.0, dimensions.width - 50);
        double y = ThreadLocalRandom.current().nextDouble(50.0, dimensions.height - 50);
        page.mouse().move(x, y);
    }

    private static void executeScrollDown(Page page) {
        int distance = ThreadLocalRandom.current().nextInt(100, 600);
        page.evaluate("window.scrollBy(0, " + distance + ")");
    }

    private static void executeScrollUp(Page page) {
        int distance = ThreadLocalRandom.current().nextInt(50, 300);
        page.evaluate("window.scrollBy(0, -" + distance + ")");
    }

    private static void executeScrollToRandom(Page page) {
        double position = ThreadLocalRandom.current().nextDouble(0.1, 0.9);
        page.evaluate("window.scrollTo(0, document.body.scrollHeight * " + position + ")");
    }

    private static void executeSafeHover(Page page) {
        String[] safeSelectors = new String[]{"p", "div", "span", "h1", "h2", "h3", "h4", "h5", "h6", "img"};
        String selector = safeSelectors[ThreadLocalRandom.current().nextInt(safeSelectors.length)];
        try {
            if (page.locator(selector).first().isVisible()) {
                page.locator(selector).first().hover();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void executeMouseTrack(Page page, PageDimensions dimensions) {
        double startX = ThreadLocalRandom.current().nextDouble(100.0, dimensions.width - 100);
        double startY = ThreadLocalRandom.current().nextDouble(100.0, dimensions.height - 100);
        int trackPoints = ThreadLocalRandom.current().nextInt(2, 5);
        for (int i = 0; i < trackPoints; ++i) {
            double deltaX = ThreadLocalRandom.current().nextDouble(-80.0, 80.0);
            double deltaY = ThreadLocalRandom.current().nextDouble(-50.0, 50.0);
            double newX = Math.max(50.0, Math.min((double)(dimensions.width - 50), startX + deltaX));
            double newY = Math.max(50.0, Math.min((double)(dimensions.height - 50), startY + deltaY));
            page.mouse().move(newX, newY);
            try {
                Thread.sleep(ThreadLocalRandom.current().nextInt(20, 80));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            startX = newX;
            startY = newY;
        }
    }

    private static void executeGentleDrag(Page page, PageDimensions dimensions) {
        double startX = ThreadLocalRandom.current().nextDouble((double)dimensions.width * 0.3, (double)dimensions.width * 0.7);
        double startY = ThreadLocalRandom.current().nextDouble((double)dimensions.height * 0.3, (double)dimensions.height * 0.7);
        double endX = startX + (double)ThreadLocalRandom.current().nextInt(-30, 30);
        double endY = startY + (double)ThreadLocalRandom.current().nextInt(-20, 20);
        endX = Math.max((double)dimensions.width * 0.2, Math.min((double)dimensions.width * 0.8, endX));
        endY = Math.max((double)dimensions.height * 0.2, Math.min((double)dimensions.height * 0.8, endY));
        page.mouse().move(startX, startY);
        page.mouse().down();
        page.mouse().move(endX, endY);
        page.mouse().up();
    }

    private static long calculateSmartDelay(long remainingTime, BehaviorIntensity intensity) {
        if (remainingTime <= 50L) {
            return 0L;
        }
        long maxDelay = Math.min(remainingTime / 2L, 800L);
        if (intensity.isQuick()) {
            return ThreadLocalRandom.current().nextLong(20L, Math.min(maxDelay, 150L));
        }
        if (intensity.isThorough()) {
            return HumanBehaviorSimulator.naturalRandomDelay(Math.max(50L, Math.min(maxDelay, 600L)));
        }
        return HumanBehaviorSimulator.naturalRandomDelay(Math.max(30L, Math.min(maxDelay, 400L)));
    }

    private static long naturalRandomDelay(long maxDelay) {
        double random = ThreadLocalRandom.current().nextDouble();
        if (random < 0.6) {
            return ThreadLocalRandom.current().nextLong(30L, Math.max(31L, maxDelay / 3L));
        }
        if (random < 0.9) {
            return ThreadLocalRandom.current().nextLong(maxDelay / 3L, Math.max(maxDelay / 3L + 1L, maxDelay * 2L / 3L));
        }
        return ThreadLocalRandom.current().nextLong(maxDelay * 2L / 3L, maxDelay);
    }

    private static PageDimensions getPageDimensions(Page page) {
        try {
            Object result = page.evaluate("() => ({width: window.innerWidth, height: window.innerHeight})");
            if (result instanceof Map) {
                Map dimensions = (Map)result;
                int width = ((Number)dimensions.get("width")).intValue();
                int height = ((Number)dimensions.get("height")).intValue();
                return new PageDimensions(Math.max(width, 800), Math.max(height, 600));
            }
        }
        catch (Exception e) {
            log.debug("Failed to get page dimensions, using defaults", (Throwable)e);
        }
        return new PageDimensions(1280, 720);
    }

    private static class PageDimensions {
        final int width;
        final int height;

        PageDimensions(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }

    private static enum SafeAction {
        MOUSE_MOVE,
        SCROLL_DOWN,
        SCROLL_UP,
        SCROLL_TO,
        HOVER_ELEMENT,
        MOUSE_TRACK,
        GENTLE_DRAG;

    }
}

