/*
 * Decompiled with CFR 0.152.
 */
package cn.xuanyuanli.playwright.stealth.manager;

import cn.xuanyuanli.playwright.stealth.config.PlaywrightConfig;
import cn.xuanyuanli.playwright.stealth.manager.PlaywrightManager;
import cn.xuanyuanli.playwright.stealth.pool.PlaywrightBrowserFactory;
import com.microsoft.playwright.Browser;
import com.microsoft.playwright.BrowserContext;
import com.microsoft.playwright.Page;
import java.time.Duration;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaywrightBrowserManager
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlaywrightBrowserManager.class);
    private final GenericObjectPool<Browser> pool;
    private final PlaywrightConfig playwrightConfig;

    public PlaywrightBrowserManager(PlaywrightConfig playwrightConfig, int capacity) {
        this(null, playwrightConfig, capacity);
    }

    public PlaywrightBrowserManager(GenericObjectPoolConfig<Browser> poolConfig, PlaywrightConfig playwrightConfig, int capacity) {
        if (playwrightConfig == null) {
            playwrightConfig = new PlaywrightConfig();
        }
        this.playwrightConfig = playwrightConfig;
        if (poolConfig == null) {
            poolConfig = new GenericObjectPoolConfig();
            poolConfig.setTestOnBorrow(true);
            poolConfig.setTestOnReturn(false);
            poolConfig.setMaxTotal(capacity);
            poolConfig.setMaxIdle(capacity);
            poolConfig.setMinIdle(1);
            poolConfig.setTimeBetweenEvictionRuns(Duration.ofMinutes(30L));
            poolConfig.setMinEvictableIdleDuration(Duration.ofHours(1L));
            poolConfig.setTestWhileIdle(true);
            poolConfig.setBlockWhenExhausted(true);
            poolConfig.setMaxWait(Duration.ofSeconds(30L));
        }
        this.pool = new GenericObjectPool((PooledObjectFactory)new PlaywrightBrowserFactory(playwrightConfig), poolConfig);
        log.info("PlaywrightBrowserManager initialized with pool capacity: {}, config: {}", (Object)capacity, (Object)playwrightConfig);
    }

    public void execute(Consumer<Page> pageConsumer) {
        this.execute(null, pageConsumer);
    }

    public void execute(Consumer<BrowserContext> browserContextConsumer, Consumer<Page> pageConsumer) {
        Browser browser = null;
        try {
            browser = (Browser)this.pool.borrowObject();
            log.debug("Browser borrowed from pool. Pool status: {}", (Object)this.getPoolStatus());
            PlaywrightManager.executeWithBrowser(this.playwrightConfig, browserContextConsumer, pageConsumer, browser);
        }
        catch (Exception e) {
            log.error("Failed to execute browser operation", (Throwable)e);
            throw new RuntimeException("Browser operation failed", e);
        }
        finally {
            if (browser != null) {
                try {
                    this.pool.returnObject((Object)browser);
                    log.debug("Browser returned to pool. Pool status: {}", (Object)this.getPoolStatus());
                }
                catch (Exception e) {
                    log.warn("Failed to return browser object to pool", (Throwable)e);
                }
            }
        }
    }

    public String getPoolStatus() {
        return String.format("Browser Pool Status - Active: %d, Idle: %d, Total: %d/%d, Waited: %d", this.pool.getNumActive(), this.pool.getNumIdle(), this.pool.getNumActive() + this.pool.getNumIdle(), this.pool.getMaxTotal(), this.pool.getNumWaiters());
    }

    public String getPoolStatistics() {
        return String.format("Browser Pool Statistics - Created: %d, Borrowed: %d, Returned: %d, Destroyed: %d, Active: %d, Idle: %d, Waiters: %d", this.pool.getCreatedCount(), this.pool.getBorrowedCount(), this.pool.getReturnedCount(), this.pool.getDestroyedCount(), this.pool.getNumActive(), this.pool.getNumIdle(), this.pool.getNumWaiters());
    }

    public void evictIdleBrowsers() {
        try {
            this.pool.evict();
            log.info("Evicted idle browsers from pool");
        }
        catch (Exception e) {
            log.warn("Failed to evict idle browsers", (Throwable)e);
        }
    }

    public void warmUpPool(int count) {
        log.info("Warming up browser pool with {} instances", (Object)count);
        for (int i = 0; i < count; ++i) {
            try {
                Browser browser = (Browser)this.pool.borrowObject();
                this.pool.returnObject((Object)browser);
                continue;
            }
            catch (Exception e) {
                log.warn("Failed to warm up browser pool at index {}", (Object)i, (Object)e);
                break;
            }
        }
        log.info("Browser pool warm up completed. Current status: {}", (Object)this.getPoolStatus());
    }

    @Override
    public void close() {
        try {
            log.info("Closing PlaywrightBrowserManager. Final statistics: {}", (Object)this.getPoolStatistics());
            this.pool.close();
            log.info("PlaywrightBrowserManager closed successfully");
        }
        catch (Exception e) {
            log.error("Error closing PlaywrightBrowserManager", (Throwable)e);
        }
    }
}

