/*
 * Decompiled with CFR 0.152.
 */
package cn.xsshome.taip.speech;

import cn.xsshome.taip.base.BaseClient;
import cn.xsshome.taip.http.TAipEBodyFormat;
import cn.xsshome.taip.http.TAipRequest;
import cn.xsshome.taip.sign.TencentAISignSort;
import cn.xsshome.taip.util.Base64Util;
import cn.xsshome.taip.util.FileUtil;
import cn.xsshome.taip.util.RandomNonceStrUtil;

public class TAipSpeech
extends BaseClient {
    public TAipSpeech(String app_id, String app_key) {
        super(app_id, app_key);
    }

    public String asrEcho(byte[] audio, int format, int rate) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(audio);
        request.addBody("speech", base64Content);
        request.addBody("format", Integer.toString(format));
        request.addBody("rate", Integer.toString(rate));
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/aai/aai_asr");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String asrEcho(String filePath, int format, int rate) throws Exception {
        byte[] audio = FileUtil.readFileByBytes(filePath);
        return this.asrEcho(audio, format, rate);
    }

    public String asrEcho(byte[] audio, int format) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(audio);
        request.addBody("speech", base64Content);
        request.addBody("format", Integer.toString(format));
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/aai/aai_asr");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String asrEcho(String filePath, int format) throws Exception {
        byte[] audio = FileUtil.readFileByBytes(filePath);
        return this.asrEcho(audio, format);
    }

    public String asrLab(int format, int rate, int seq, int len, int end, String speech_chunk) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("format", Integer.toString(format));
        request.addBody("rate", Integer.toString(rate));
        request.addBody("seq", Integer.toString(seq));
        request.addBody("len", Integer.toString(len));
        request.addBody("end", Integer.toString(end));
        request.addBody("speech_id", RandomNonceStrUtil.getRandomString(10));
        request.addBody("speech_chunk", speech_chunk);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/aai/aai_asrs");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String asrLab(int format, int rate, int seq, int len, int end, byte[] audio) throws Exception {
        String base64Content = Base64Util.encode(audio);
        return this.asrLab(format, rate, seq, len, end, base64Content);
    }

    public String asrLab(String filePath, int format, int rate, int seq, int len, int end) throws Exception {
        String base64Content = Base64Util.encode(FileUtil.readFileByBytes(filePath));
        return this.asrLab(format, rate, seq, len, end, base64Content);
    }

    public String asrWx(byte[] audio, int format, int rate, int bits, int seq, int len, int end, int cont_res) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("format", Integer.toString(format));
        request.addBody("rate", Integer.toString(rate));
        request.addBody("seq", Integer.toString(seq));
        request.addBody("len", Integer.toString(len));
        request.addBody("end", Integer.toString(end));
        request.addBody("bits", Integer.toString(bits));
        request.addBody("cont_res", Integer.toString(cont_res));
        request.addBody("speech_id", RandomNonceStrUtil.getRandomString(10));
        String speech_chunk = Base64Util.encode(audio);
        request.addBody("speech_chunk", speech_chunk);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/aai/aai_wxasrs");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String asrWx(String filePath, int format, int rate, int bits, int seq, int len, int end, int cont_res) throws Exception {
        byte[] audio = FileUtil.readFileByBytes(filePath);
        return this.asrWx(audio, format, rate, bits, seq, len, end, cont_res);
    }

    public String TtsSynthesis(String text, int speaker, int format, int volume, int speed, int aht, int apc) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("text", text);
        request.addBody("speaker", String.valueOf(speaker));
        request.addBody("format", String.valueOf(format));
        request.addBody("volume", String.valueOf(volume));
        request.addBody("speed", String.valueOf(speed));
        request.addBody("aht", String.valueOf(aht));
        request.addBody("apc", String.valueOf(apc));
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/aai/aai_tts");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String TtsSynthesis(String text, int speaker, int format) throws Exception {
        return this.TtsSynthesis(text, speaker, format, 0, 100, 0, 58);
    }

    public String TtaSynthesis(String text, int model_type, int speed) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("text", text);
        request.addBody("speed", Integer.toString(speed));
        request.addBody("model_type", Integer.toString(model_type));
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/aai/aai_tta");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String TtaSynthesis(String text) throws Exception {
        return this.TtaSynthesis(text, 0, 0);
    }

    public String asrLong(byte[] speech, int format, String callback_url) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(speech);
        request.addBody("speech", base64Content);
        request.addBody("format", Integer.toString(format));
        request.addBody("callback_url", callback_url);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/aai/aai_wxasrlong");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String asrLongByUrl(String speech_url, int format, String callback_url) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("speech_url", speech_url);
        request.addBody("format", Integer.toString(format));
        request.addBody("callback_url", callback_url);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/aai/aai_wxasrlong");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String asrLong(String speechPath, int format, String callback_url) throws Exception {
        byte[] speech = FileUtil.readFileByBytes(speechPath);
        return this.asrLong(speech, format, callback_url);
    }

    public String aaiDetectkeywordBySpeechURL(String speech_url, int format, String callback_url, String key_words) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("format", Integer.toString(format));
        request.addBody("callback_url", callback_url);
        request.addBody("key_words", key_words);
        request.addBody("speech_url", speech_url);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/aai/aai_detectkeyword");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String aaiDetectkeywordBySpeech(byte[] speech, int format, String callback_url, String key_words, Integer rate) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("format", Integer.toString(format));
        String base64Content = Base64Util.encode(speech);
        request.addBody("callback_url", callback_url);
        request.addBody("key_words", key_words);
        request.addBody("speech", base64Content);
        request.addBody("rate", Integer.toString(rate));
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/aai/aai_detectkeyword");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String aaiDetectkeywordBySpeech(String speechfilePath, int format, String callback_url, String key_words, Integer rate) throws Exception {
        byte[] speech = FileUtil.readFileByBytes(speechfilePath);
        return this.aaiDetectkeywordBySpeech(speech, format, callback_url, key_words, rate);
    }

    public String aaiDetectkeywordBySpeechURL(String speech_url, int format, String callback_url, String key_words, Integer rate) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("format", Integer.toString(format));
        request.addBody("callback_url", callback_url);
        request.addBody("key_words", key_words);
        request.addBody("speech_url", speech_url);
        request.addBody("rate", Integer.toString(rate));
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/aai/aai_detectkeyword");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }
}

