/*
 * Decompiled with CFR 0.152.
 */
package cn.xsshome.taip.ocr;

import cn.xsshome.taip.base.BaseClient;
import cn.xsshome.taip.http.TAipEBodyFormat;
import cn.xsshome.taip.http.TAipRequest;
import cn.xsshome.taip.sign.TencentAISignSort;
import cn.xsshome.taip.util.Base64Util;
import cn.xsshome.taip.util.FileUtil;
import cn.xsshome.taip.util.RandomNonceStrUtil;

public class TAipOcr
extends BaseClient {
    public TAipOcr(String app_id, String app_key) {
        super(app_id, app_key);
    }

    public String generalOcr(byte[] image) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/ocr/ocr_generalocr");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String generalOcr(String filePath) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.generalOcr(image);
    }

    public String idcardOcr(byte[] image, int card_type) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("card_type", Integer.toString(card_type));
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/ocr/ocr_idcardocr");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String idcardOcr(String filePath, int card_type) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.idcardOcr(image, card_type);
    }

    public String bcOcr(byte[] image) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/ocr/ocr_bcocr");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String bcOcr(String filePath) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.bcOcr(image);
    }

    public String driverlicenseOcr(byte[] image, int type) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.addBody("type", String.valueOf(type));
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/ocr/ocr_driverlicenseocr");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String driverlicenseOcr(String filePath, int type) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.driverlicenseOcr(image, type);
    }

    public String bizlicenseOcr(byte[] image) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/ocr/ocr_bizlicenseocr");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String bizlicenseOcr(String filePath) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.bizlicenseOcr(image);
    }

    public String creditcardOcr(byte[] image) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/ocr/ocr_creditcardocr");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String creditcardOcr(String filePath) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.creditcardOcr(image);
    }

    public String handWritingOcrByImage(byte[] image) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/ocr/ocr_handwritingocr");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String handWritingOcrByImage(String filePath) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.handWritingOcrByImage(image);
    }

    public String handWritingOcrByUrl(String image_url) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("image_url", image_url);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/ocr/ocr_handwritingocr");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String plateOcrByImage(byte[] image) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/ocr/ocr_plateocr");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String plateOcrByImage(String filePath) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.plateOcrByImage(image);
    }

    public String plateOcrByUrl(String image_url) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("image_url", image_url);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/ocr/ocr_plateocr");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }
}

