/*
 * Decompiled with CFR 0.152.
 */
package cn.xsshome.taip.nlp;

import cn.xsshome.taip.base.BaseClient;
import cn.xsshome.taip.http.TAipEBodyFormat;
import cn.xsshome.taip.http.TAipRequest;
import cn.xsshome.taip.sign.TencentAISignSort;
import cn.xsshome.taip.util.Base64Util;
import cn.xsshome.taip.util.FileUtil;
import cn.xsshome.taip.util.RandomNonceStrUtil;

public class TAipNlp
extends BaseClient {
    public TAipNlp(String app_id, String app_key) {
        super(app_id, app_key);
    }

    public String nlpWordseg(String text) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("text", text);
        String sign = TencentAISignSort.getSignatureforNLP(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/nlp/nlp_wordseg");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String nlpWordpos(String text) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("text", text);
        String sign = TencentAISignSort.getSignatureforNLP(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/nlp/nlp_wordpos");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String nlpWordner(String text) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("text", text);
        String sign = TencentAISignSort.getSignatureforNLP(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/nlp/nlp_wordner");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String nlpWordsyn(String text) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("text", text);
        String sign = TencentAISignSort.getSignatureforNLP(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/nlp/nlp_wordsyn");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String nlpWordcom(String text) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("text", text);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/nlp/nlp_wordcom");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String nlpTextpolar(String text) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("text", text);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/nlp/nlp_textpolar");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String nlpTextchat(String session, String question) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("session", session);
        request.addBody("question", question);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/nlp/nlp_textchat");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String nlpTextTrans(int type, String text) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("type", String.valueOf(type));
        request.addBody("text", text);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/nlp/nlp_texttrans");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String nlpTextTranslate(String text, String source, String target) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("text", text);
        request.addBody("source", source);
        request.addBody("target", target);
        String sign = TencentAISignSort.getSignature4TransText(request.getBody(), this.app_key);
        if (sign.contains("errorCode")) {
            return sign;
        }
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/nlp/nlp_texttranslate");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String nlpImageTranslate(byte[] image, String session_id, String scene, String source, String target) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        String imageBase64 = Base64Util.encode(image);
        request.addBody("image", imageBase64);
        request.addBody("session_id", session_id);
        request.addBody("scene", scene);
        request.addBody("source", source);
        request.addBody("target", target);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/nlp/nlp_imagetranslate");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String nlpImageTranslate(String filePath, String session_id, String scene, String source, String target) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.nlpImageTranslate(image, session_id, scene, source, target);
    }

    public String nlpTextDetect(String text, String candidate_langs, int force) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("text", text);
        if (null != candidate_langs && !candidate_langs.equals("")) {
            request.addBody("candidate_langs", candidate_langs);
        }
        request.addBody("force", String.valueOf(force));
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/nlp/nlp_textdetect");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String nlpTextDetect(String text, int force) throws Exception {
        return this.nlpTextDetect(text, "", force);
    }

    public String nlpSpeechTranslate(int format, int seq, int end, String session_id, byte[] speech_chunk, String source, String target) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("format", String.valueOf(format));
        request.addBody("seq", String.valueOf(seq));
        request.addBody("end", String.valueOf(end));
        request.addBody("session_id", session_id);
        String base64Voice = Base64Util.encode(speech_chunk);
        request.addBody("speech_chunk", base64Voice);
        request.addBody("source", source);
        request.addBody("target", target);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/nlp/nlp_speechtranslate");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String nlpSpeechTranslate(int format, int seq, int end, String session_id, String filePath, String source, String target) throws Exception {
        byte[] speech_chunk = FileUtil.readFileByBytes(filePath);
        return this.nlpSpeechTranslate(format, seq, end, session_id, speech_chunk, source, target);
    }
}

