/*
 * Decompiled with CFR 0.152.
 */
package cn.xsshome.taip.http;

import cn.xsshome.taip.http.TAipClientConfiguration;
import cn.xsshome.taip.http.TAipEBodyFormat;
import cn.xsshome.taip.http.TAipHttpMethodName;
import cn.xsshome.taip.util.Util;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TAipRequest {
    private HashMap<String, String> headers;
    private HashMap<String, String> params;
    private HashMap<String, String> body;
    private URI uri;
    private TAipHttpMethodName httpMethod;
    private TAipEBodyFormat bodyFormat;
    private String contentEncoding;
    private TAipClientConfiguration config;

    public TAipRequest() {
        this.headers = new HashMap();
        this.params = new HashMap();
        this.body = new HashMap();
        this.httpMethod = TAipHttpMethodName.POST;
        this.bodyFormat = TAipEBodyFormat.FORM_KV;
        this.contentEncoding = "UTF8";
        this.config = null;
    }

    public TAipRequest(HashMap<String, String> header, HashMap<String, String> bodyParams) {
        this.headers = header;
        this.params = bodyParams;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public TAipEBodyFormat getBodyFormat() {
        return this.bodyFormat;
    }

    public void setBodyFormat(TAipEBodyFormat bodyFormat) {
        this.bodyFormat = bodyFormat;
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
        if (key.equals("Content-Encoding")) {
            this.contentEncoding = value;
        }
    }

    public void addParam(String key, String value) {
        this.params.put(key, value);
    }

    public void addBody(String key, String value) {
        this.body.put(key, value);
    }

    public void addBody(HashMap other) {
        if (other != null) {
            this.body.putAll(other);
        }
    }

    public HashMap<String, String> getParams() {
        return this.params;
    }

    public String getBodyStr() {
        ArrayList<String> arr = new ArrayList<String>();
        if (this.bodyFormat.equals((Object)TAipEBodyFormat.FORM_KV)) {
            for (Map.Entry<String, String> entry : this.body.entrySet()) {
                if (entry.getValue() == null || entry.getValue().equals("")) {
                    arr.add(Util.uriEncode(entry.getKey(), true));
                    continue;
                }
                arr.add(String.format("%s=%s", Util.uriEncode(entry.getKey(), true), Util.uriEncode(entry.getValue().toString(), true)));
            }
            return Util.mkString(arr.iterator(), '&');
        }
        if (this.bodyFormat.equals((Object)TAipEBodyFormat.RAW_JSON_ARRAY)) {
            return this.body.get("body");
        }
        return "";
    }

    public String getBodyStrForNLP() {
        ArrayList<String> arr = new ArrayList<String>();
        if (this.bodyFormat.equals((Object)TAipEBodyFormat.FORM_KV)) {
            for (Map.Entry<String, String> entry : this.body.entrySet()) {
                if (entry.getValue() == null || entry.getValue().equals("")) {
                    arr.add(Util.uriEncode(entry.getKey(), true));
                    continue;
                }
                if (entry.getKey().equals("text")) {
                    arr.add(String.format("%s=%s", Util.uriEncodeGBK(entry.getKey(), false), Util.uriEncodeGBK(entry.getValue().toString(), false)));
                    continue;
                }
                arr.add(String.format("%s=%s", Util.uriEncode(entry.getKey(), true), Util.uriEncode(entry.getValue().toString(), true)));
            }
            return Util.mkString(arr.iterator(), '&');
        }
        if (this.bodyFormat.equals((Object)TAipEBodyFormat.RAW_JSON_ARRAY)) {
            return this.body.get("body");
        }
        return "";
    }

    public String getParamStr() {
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            buffer.append(String.format("%s=%s&", entry.getKey(), entry.getValue()));
        }
        if (buffer.length() > 0) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer.toString();
    }

    public HashMap<String, String> getBody() {
        return this.body;
    }

    public void setBody(HashMap<String, String> body) {
        this.body = body;
    }

    public void setParams(HashMap<String, String> params) {
        this.params = params;
    }

    public HashMap<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(HashMap<String, String> headers) {
        this.headers = headers;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public void setUri(String url) {
        try {
            this.uri = new URI(url);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public TAipHttpMethodName getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(TAipHttpMethodName httpMethod) {
        this.httpMethod = httpMethod;
    }

    public TAipClientConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(TAipClientConfiguration config) {
        this.config = config;
    }
}

