/*
 * Decompiled with CFR 0.152.
 */
package cn.xsshome.taip.base;

import cn.xsshome.taip.error.ErrorTAip;
import cn.xsshome.taip.http.TAipClientConfiguration;
import cn.xsshome.taip.http.TAipHttpClient;
import cn.xsshome.taip.http.TAipRequest;
import cn.xsshome.taip.http.TAipResponse;
import java.net.Proxy;

public abstract class BaseClient {
    protected String app_id;
    protected String app_key;
    protected TAipClientConfiguration config;

    protected BaseClient(String app_id, String app_key) {
        this.app_id = app_id;
        this.app_key = app_key;
    }

    protected String requestServer(TAipRequest request) {
        request.setConfig(this.config);
        long startTime = System.currentTimeMillis();
        TAipResponse response = TAipHttpClient.post(request);
        long endTime = System.currentTimeMillis();
        long timeStamp = endTime - startTime;
        int resStatus = response.getStatus();
        if (resStatus != 200) {
            return ErrorTAip.APISERVICE_ERROR.toJsonResult("\u63a5\u53e3\u670d\u52a1\u5f02\u5e38  \u8017\u65f6(\u6beb\u79d2):" + timeStamp + " HTTP STATUS:" + resStatus + " \u8bf7\u8054\u7cfb\u817e\u8bafAI\u7684\u5b98\u65b9\u4eba\u5458");
        }
        String resData = response.getBodyStr();
        return resData;
    }

    public void setConnectionTimeoutInMillis(int timeout) {
        if (this.config == null) {
            this.config = new TAipClientConfiguration();
        }
        this.config.setConnectionTimeoutMillis(timeout);
    }

    public void setSocketTimeoutInMillis(int timeout) {
        if (this.config == null) {
            this.config = new TAipClientConfiguration();
        }
        this.config.setSocketTimeoutMillis(timeout);
    }

    public void setHttpProxy(String host, int port) {
        if (this.config == null) {
            this.config = new TAipClientConfiguration();
        }
        this.config.setProxy(host, port, Proxy.Type.HTTP);
    }

    public void setSocketProxy(String host, int port) {
        if (this.config == null) {
            this.config = new TAipClientConfiguration();
        }
        this.config.setProxy(host, port, Proxy.Type.SOCKS);
    }
}

