/*
 * Decompiled with CFR 0.152.
 */
package cn.xsshome.taip.face;

import cn.xsshome.taip.base.BaseClient;
import cn.xsshome.taip.http.TAipEBodyFormat;
import cn.xsshome.taip.http.TAipRequest;
import cn.xsshome.taip.sign.TencentAISignSort;
import cn.xsshome.taip.util.Base64Util;
import cn.xsshome.taip.util.FileUtil;
import cn.xsshome.taip.util.RandomNonceStrUtil;
import java.util.ArrayList;
import java.util.List;

public class TAipFace
extends BaseClient {
    public TAipFace(String app_id, String app_key) {
        super(app_id, app_key);
    }

    public String detect(byte[] image) throws Exception {
        TAipRequest request = new TAipRequest();
        String result = "";
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.addBody("mode", "1");
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/face/face_detectface");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    @Deprecated
    public String detectByUrl(String url) throws Exception {
        TAipRequest request = new TAipRequest();
        String result = "";
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("image_url", url);
        request.addBody("mode", "1");
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/face/face_detectface");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String detect(String filePath) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.detect(image);
    }

    public String detectMulti(byte[] image) throws Exception {
        TAipRequest request = new TAipRequest();
        String result = "";
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/face/face_detectmultiface");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String detectMulti(String filePath) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.detectMulti(image);
    }

    public String faceCompare(byte[] image_a, byte[] image_b) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64ContentA = Base64Util.encode(image_a);
        String base64ContentB = Base64Util.encode(image_b);
        request.addBody("image_a", base64ContentA);
        request.addBody("image_b", base64ContentB);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/face/face_facecompare");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String faceCompare(String filePathA, String filePathB) throws Exception {
        byte[] imageA = FileUtil.readFileByBytes(filePathA);
        byte[] imageB = FileUtil.readFileByBytes(filePathB);
        return this.faceCompare(imageA, imageB);
    }

    public String detectCrossage(byte[] source_image, byte[] target_image) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64ContentA = Base64Util.encode(source_image);
        String base64ContentB = Base64Util.encode(target_image);
        request.addBody("source_image", base64ContentA);
        request.addBody("target_image", base64ContentB);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/face/face_detectcrossageface");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String detectCrossage(String source_imagefilePath, String target_imagefilePath) throws Exception {
        byte[] imageA = FileUtil.readFileByBytes(source_imagefilePath);
        byte[] imageB = FileUtil.readFileByBytes(target_imagefilePath);
        return this.detectCrossage(imageA, imageB);
    }

    public String faceShape(byte[] image) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.addBody("mode", "1");
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/face/face_faceshape");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String faceShape(String filePath) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.faceShape(image);
    }

    public String faceIdentify(byte[] image, String group_id, int topn) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.addBody("group_id", group_id);
        request.addBody("topn", String.valueOf(topn));
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/face/face_faceidentify");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String faceIdentify(String filePath, String group_id, int topn) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.faceIdentify(image, group_id, topn);
    }

    public String faceVerify(byte[] image, String person_id) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.addBody("person_id", person_id);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/face/face_faceverify");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String faceVerify(String filePath, String person_id) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.faceVerify(image, person_id);
    }

    public String faceNewperson(byte[] image, String group_ids, String person_id, String person_name, String tag) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.addBody("group_ids", group_ids);
        request.addBody("person_id", person_id);
        request.addBody("person_name", person_name);
        request.addBody("tag", tag);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/face/face_newperson");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String faceNewperson(String filePath, String group_ids, String person_id, String person_name, String tag) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.faceNewperson(image, group_ids, person_id, person_name, tag);
    }

    public String faceNewperson(byte[] image, String group_ids, String person_id, String person_name) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        request.addBody("group_ids", group_ids);
        request.addBody("person_id", person_id);
        request.addBody("person_name", person_name);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/face/face_newperson");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String faceNewperson(String filePath, String group_ids, String person_id, String person_name) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.faceNewperson(image, group_ids, person_id, person_name);
    }

    public String faceDelperson(String person_id) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("person_id", person_id);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/face/face_delperson");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String faceAddfaceByte(List<byte[]> images, String person_id, String tag) throws Exception {
        String result = "";
        String imagestr = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        for (int i = 0; i < images.size(); ++i) {
            imagestr = imagestr + Base64Util.encode(images.get(i)) + "|";
        }
        imagestr = imagestr.substring(0, imagestr.length() - 1);
        request.addBody("person_id", person_id);
        request.addBody("images", imagestr);
        request.addBody("tag", tag);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/face/face_addface");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String faceAddfaceByFilePath(List<String> filePaths, String person_id, String tag) throws Exception {
        ArrayList<byte[]> images = new ArrayList<byte[]>();
        for (int i = 0; i < filePaths.size(); ++i) {
            images.add(FileUtil.readFileByBytes(filePaths.get(i)));
        }
        return this.faceAddfaceByte(images, person_id, tag);
    }

    public String faceDelFace(String person_id, String face_ids) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("person_id", person_id);
        request.addBody("face_ids", face_ids);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/face/face_delface");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String faceSetInfo(String person_id, String person_name, String tag) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("person_id", person_id);
        request.addBody("person_name", person_name);
        request.addBody("tag", tag);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/face/face_setinfo");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String faceGetInfo(String person_id) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("person_id", person_id);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/face/face_getinfo");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String getGroupIds() throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/face/face_getgroupids");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String getPersonIds(String group_id) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("group_id", group_id);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/face/face_getpersonids");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String getFaceIds(String person_id) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("person_id", person_id);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/face/face_getfaceids");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }

    public String getFaceInfo(String face_id) throws Exception {
        String result = "";
        TAipRequest request = new TAipRequest();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        request.addBody("app_id", this.app_id);
        request.addBody("time_stamp", time_stamp);
        request.addBody("nonce_str", RandomNonceStrUtil.getRandomString());
        request.addBody("face_id", face_id);
        String sign = TencentAISignSort.getSignature(request.getBody(), this.app_key);
        request.addBody("sign", sign);
        request.setUri("https://api.ai.qq.com/fcgi-bin/face/face_getfaceinfo");
        request.setBodyFormat(TAipEBodyFormat.FORM_KV);
        result = this.requestServer(request);
        return result;
    }
}

