/*
 * Decompiled with CFR 0.152.
 */
package cn.xsshome.taip.base;

import cn.xsshome.taip.http.TAipClientConfiguration;
import cn.xsshome.taip.http.TAipHttpClient;
import cn.xsshome.taip.http.TAipRequest;
import cn.xsshome.taip.http.TAipResponse;
import java.net.Proxy;

public abstract class BaseClient {
    protected String app_id;
    protected String app_key;
    protected TAipClientConfiguration config;

    protected BaseClient(String app_id, String app_key) {
        this.app_id = app_id;
        this.app_key = app_key;
    }

    protected String requestServer(TAipRequest request) {
        request.setConfig(this.config);
        TAipResponse response = TAipHttpClient.post(request);
        String resData = response.getBodyStr();
        return resData;
    }

    public void setConnectionTimeoutInMillis(int timeout) {
        if (this.config == null) {
            this.config = new TAipClientConfiguration();
        }
        this.config.setConnectionTimeoutMillis(timeout);
    }

    public void setSocketTimeoutInMillis(int timeout) {
        if (this.config == null) {
            this.config = new TAipClientConfiguration();
        }
        this.config.setSocketTimeoutMillis(timeout);
    }

    public void setHttpProxy(String host, int port) {
        if (this.config == null) {
            this.config = new TAipClientConfiguration();
        }
        this.config.setProxy(host, port, Proxy.Type.HTTP);
    }

    public void setSocketProxy(String host, int port) {
        if (this.config == null) {
            this.config = new TAipClientConfiguration();
        }
        this.config.setProxy(host, port, Proxy.Type.SOCKS);
    }
}

