/*
 * Decompiled with CFR 0.152.
 */
package cn.xsshome.taip.speech;

import cn.xsshome.taip.base.BaseClient;
import cn.xsshome.taip.http.HttpUtil;
import cn.xsshome.taip.sign.TencentAISignSort;
import cn.xsshome.taip.util.Base64Util;
import cn.xsshome.taip.util.FileUtil;
import cn.xsshome.taip.util.RandomNonceStrUtil;
import java.util.HashMap;

public class TAipSpeech
extends BaseClient {
    public TAipSpeech(String app_id, String app_key) {
        super(app_id, app_key);
    }

    public String asrEcho(byte[] audio, int format, int rate) throws Exception {
        String result = "";
        HashMap<String, String> params = new HashMap<String, String>();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        params.put("app_id", this.app_id);
        params.put("time_stamp", time_stamp);
        params.put("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(audio);
        params.put("speech", base64Content);
        params.put("format", Integer.toString(format));
        params.put("rate", Integer.toString(rate));
        String sign = TencentAISignSort.getSignature(params, this.app_key);
        params.put("sign", sign);
        result = HttpUtil.post("https://api.ai.qq.com/fcgi-bin/aai/aai_asr", TencentAISignSort.getParams(params));
        return result;
    }

    public String asrEcho(String filePath, int format, int rate) throws Exception {
        byte[] audio = FileUtil.readFileByBytes(filePath);
        return this.asrEcho(audio, format, rate);
    }

    public String asrEcho(byte[] audio, int format) throws Exception {
        String result = "";
        HashMap<String, String> params = new HashMap<String, String>();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        params.put("app_id", this.app_id);
        params.put("time_stamp", time_stamp);
        params.put("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(audio);
        params.put("speech", base64Content);
        params.put("format", Integer.toString(format));
        String sign = TencentAISignSort.getSignature(params, this.app_key);
        params.put("sign", sign);
        result = HttpUtil.post("https://api.ai.qq.com/fcgi-bin/aai/aai_asr", TencentAISignSort.getParams(params));
        return result;
    }

    public String asrEcho(String filePath, int format) throws Exception {
        byte[] audio = FileUtil.readFileByBytes(filePath);
        return this.asrEcho(audio, format);
    }

    public String asrLab(int format, int rate, int seq, int len, int end, String speech_chunk) throws Exception {
        String result = "";
        HashMap<String, String> params = new HashMap<String, String>();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        params.put("app_id", this.app_id);
        params.put("time_stamp", time_stamp);
        params.put("nonce_str", RandomNonceStrUtil.getRandomString());
        params.put("format", Integer.toString(format));
        params.put("rate", Integer.toString(rate));
        params.put("seq", Integer.toString(seq));
        params.put("len", Integer.toString(len));
        params.put("end", Integer.toString(end));
        params.put("speech_id", RandomNonceStrUtil.getRandomString(10));
        params.put("speech_chunk", speech_chunk);
        String sign = TencentAISignSort.getSignature(params, this.app_key);
        params.put("sign", sign);
        result = HttpUtil.post("https://api.ai.qq.com/fcgi-bin/aai/aai_asrs", TencentAISignSort.getParams(params));
        return result;
    }

    public String asrLab(int format, int rate, int seq, int len, int end, byte[] audio) throws Exception {
        String base64Content = Base64Util.encode(audio);
        return this.asrLab(format, rate, seq, len, end, base64Content);
    }

    public String asrLab(String filePath, int format, int rate, int seq, int len, int end, String speech_id) throws Exception {
        String base64Content = Base64Util.encode(FileUtil.readFileByBytes(filePath));
        return this.asrLab(format, rate, seq, len, end, base64Content);
    }

    public String asrWx(byte[] audio, int format, int rate, int bits, int seq, int len, int end, int cont_res) throws Exception {
        String result = "";
        HashMap<String, String> params = new HashMap<String, String>();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        params.put("app_id", this.app_id);
        params.put("time_stamp", time_stamp);
        params.put("nonce_str", RandomNonceStrUtil.getRandomString());
        params.put("format", Integer.toString(format));
        params.put("rate", Integer.toString(rate));
        params.put("seq", Integer.toString(seq));
        params.put("len", Integer.toString(len));
        params.put("end", Integer.toString(end));
        params.put("bits", Integer.toString(bits));
        params.put("cont_res", Integer.toString(cont_res));
        params.put("speech_id", RandomNonceStrUtil.getRandomString(10));
        String speech_chunk = Base64Util.encode(audio);
        params.put("speech_chunk", speech_chunk);
        String sign = TencentAISignSort.getSignature(params, this.app_key);
        params.put("sign", sign);
        result = HttpUtil.post("https://api.ai.qq.com/fcgi-bin/aai/aai_wxasrs", TencentAISignSort.getParams(params));
        return result;
    }

    public String asrWx(String filePath, int format, int rate, int bits, int seq, int len, int end, int cont_res) throws Exception {
        byte[] audio = FileUtil.readFileByBytes(filePath);
        return this.asrWx(audio, format, rate, bits, seq, len, end, cont_res);
    }
}

