/*
 * Decompiled with CFR 0.152.
 */
package cn.xsshome.taip.ocr;

import cn.xsshome.taip.base.BaseClient;
import cn.xsshome.taip.http.HttpUtil;
import cn.xsshome.taip.sign.TencentAISignSort;
import cn.xsshome.taip.util.Base64Util;
import cn.xsshome.taip.util.FileUtil;
import cn.xsshome.taip.util.RandomNonceStrUtil;
import java.util.HashMap;

public class TAipOcr
extends BaseClient {
    public TAipOcr(String app_id, String app_key) {
        super(app_id, app_key);
    }

    public String generalOcr(byte[] image) throws Exception {
        String result = "";
        HashMap<String, String> params = new HashMap<String, String>();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        params.put("app_id", this.app_id);
        params.put("time_stamp", time_stamp);
        params.put("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(image);
        params.put("image", base64Content);
        String sign = TencentAISignSort.getSignature(params, this.app_key);
        params.put("sign", sign);
        result = HttpUtil.post("https://api.ai.qq.com/fcgi-bin/ocr/ocr_generalocr", TencentAISignSort.getParams(params));
        return result;
    }

    public String generalOcr(String filePath) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.generalOcr(image);
    }

    public String idcardOcr(byte[] image, int card_type) throws Exception {
        String result = "";
        HashMap<String, String> params = new HashMap<String, String>();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        params.put("app_id", this.app_id);
        params.put("time_stamp", time_stamp);
        params.put("nonce_str", RandomNonceStrUtil.getRandomString());
        params.put("card_type", Integer.toString(card_type));
        String base64Content = Base64Util.encode(image);
        params.put("image", base64Content);
        String sign = TencentAISignSort.getSignature(params, this.app_key);
        params.put("sign", sign);
        result = HttpUtil.post("https://api.ai.qq.com/fcgi-bin/ocr/ocr_idcardocr", TencentAISignSort.getParams(params));
        return result;
    }

    public String idcardOcr(String filePath, int card_type) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.idcardOcr(image, card_type);
    }

    public String bcOcr(byte[] image) throws Exception {
        String result = "";
        HashMap<String, String> params = new HashMap<String, String>();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        params.put("app_id", this.app_id);
        params.put("time_stamp", time_stamp);
        params.put("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(image);
        params.put("image", base64Content);
        String sign = TencentAISignSort.getSignature(params, this.app_key);
        params.put("sign", sign);
        result = HttpUtil.post("https://api.ai.qq.com/fcgi-bin/ocr/ocr_bcocr", TencentAISignSort.getParams(params));
        return result;
    }

    public String bcOcr(String filePath) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.bcOcr(image);
    }

    public String driverlicenseOcr(byte[] image) throws Exception {
        String result = "";
        HashMap<String, String> params = new HashMap<String, String>();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        params.put("app_id", this.app_id);
        params.put("time_stamp", time_stamp);
        params.put("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(image);
        params.put("image", base64Content);
        String sign = TencentAISignSort.getSignature(params, this.app_key);
        params.put("sign", sign);
        result = HttpUtil.post("https://api.ai.qq.com/fcgi-bin/ocr/ocr_driverlicenseocr", TencentAISignSort.getParams(params));
        return result;
    }

    public String driverlicenseOcr(String filePath) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.driverlicenseOcr(image);
    }

    public String bizlicenseOcr(byte[] image) throws Exception {
        String result = "";
        HashMap<String, String> params = new HashMap<String, String>();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        params.put("app_id", this.app_id);
        params.put("time_stamp", time_stamp);
        params.put("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(image);
        params.put("image", base64Content);
        String sign = TencentAISignSort.getSignature(params, this.app_key);
        params.put("sign", sign);
        result = HttpUtil.post("https://api.ai.qq.com/fcgi-bin/ocr/ocr_bizlicenseocr", TencentAISignSort.getParams(params));
        return result;
    }

    public String bizlicenseOcr(String filePath) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.bizlicenseOcr(image);
    }

    public String creditcardOcr(byte[] image) throws Exception {
        String result = "";
        HashMap<String, String> params = new HashMap<String, String>();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        params.put("app_id", this.app_id);
        params.put("time_stamp", time_stamp);
        params.put("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(image);
        params.put("image", base64Content);
        String sign = TencentAISignSort.getSignature(params, this.app_key);
        params.put("sign", sign);
        result = HttpUtil.post("https://api.ai.qq.com/fcgi-bin/ocr/ocr_creditcardocr", TencentAISignSort.getParams(params));
        return result;
    }

    public String creditcardOcr(String filePath) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.creditcardOcr(image);
    }
}

