/*
 * Decompiled with CFR 0.152.
 */
package cn.xsshome.taip.imageclassify;

import cn.xsshome.taip.base.BaseClient;
import cn.xsshome.taip.http.HttpUtil;
import cn.xsshome.taip.sign.TencentAISignSort;
import cn.xsshome.taip.util.Base64Util;
import cn.xsshome.taip.util.FileUtil;
import cn.xsshome.taip.util.RandomNonceStrUtil;
import java.util.HashMap;

public class TAipImageClassify
extends BaseClient {
    public TAipImageClassify(String app_id, String app_key) {
        super(app_id, app_key);
    }

    public String visionScener(byte[] image, int format, int topk) throws Exception {
        String result = "";
        HashMap<String, String> params = new HashMap<String, String>();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        params.put("app_id", this.app_id);
        params.put("time_stamp", time_stamp);
        params.put("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(image);
        params.put("image", base64Content);
        params.put("format", Integer.toString(format));
        params.put("topk", Integer.toString(topk));
        String sign = TencentAISignSort.getSignature(params, this.app_key);
        params.put("sign", sign);
        result = HttpUtil.post("https://api.ai.qq.com/fcgi-bin/vision/vision_scener", TencentAISignSort.getParams(params));
        return result;
    }

    public String visionScener(String filePath, int format, int topk) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.visionScener(image, format, topk);
    }

    public String visionObjectr(byte[] image, int format, int topk) throws Exception {
        String result = "";
        HashMap<String, String> params = new HashMap<String, String>();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        params.put("app_id", this.app_id);
        params.put("time_stamp", time_stamp);
        params.put("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(image);
        params.put("image", base64Content);
        params.put("format", Integer.toString(format));
        params.put("topk", Integer.toString(topk));
        String sign = TencentAISignSort.getSignature(params, this.app_key);
        params.put("sign", sign);
        result = HttpUtil.post("https://api.ai.qq.com/fcgi-bin/vision/vision_objectr", TencentAISignSort.getParams(params));
        return result;
    }

    public String visionObjectr(String filePath, int format, int topk) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.visionObjectr(image, format, topk);
    }

    public String imageTag(byte[] image) throws Exception {
        String result = "";
        HashMap<String, String> params = new HashMap<String, String>();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        params.put("app_id", this.app_id);
        params.put("time_stamp", time_stamp);
        params.put("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(image);
        params.put("image", base64Content);
        String sign = TencentAISignSort.getSignature(params, this.app_key);
        params.put("sign", sign);
        result = HttpUtil.post("https://api.ai.qq.com/fcgi-bin/image/image_tag", TencentAISignSort.getParams(params));
        return result;
    }

    public String imageTag(String filePath) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.imageTag(image);
    }

    public String visionImgidentify(byte[] image, int scene) throws Exception {
        String result = "";
        HashMap<String, String> params = new HashMap<String, String>();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        params.put("app_id", this.app_id);
        params.put("time_stamp", time_stamp);
        params.put("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(image);
        params.put("image", base64Content);
        params.put("scene", Integer.toString(scene));
        String sign = TencentAISignSort.getSignature(params, this.app_key);
        params.put("sign", sign);
        result = HttpUtil.post("https://api.ai.qq.com/fcgi-bin/vision/vision_imgidentify", TencentAISignSort.getParams(params));
        return result;
    }

    public String visionImgidentify(String filePath, int scene) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.visionImgidentify(image, scene);
    }

    public String flowersAndPlant(byte[] image) throws Exception {
        String result = "";
        HashMap<String, String> params = new HashMap<String, String>();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        params.put("app_id", this.app_id);
        params.put("time_stamp", time_stamp);
        params.put("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(image);
        params.put("image", base64Content);
        params.put("scene", "2");
        String sign = TencentAISignSort.getSignature(params, this.app_key);
        params.put("sign", sign);
        result = HttpUtil.post("https://api.ai.qq.com/fcgi-bin/vision/vision_imgidentify", TencentAISignSort.getParams(params));
        return result;
    }

    public String flowersAndPlant(String filePath) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.flowersAndPlant(image);
    }

    public String vehicle(byte[] image) throws Exception {
        String result = "";
        HashMap<String, String> params = new HashMap<String, String>();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        params.put("app_id", this.app_id);
        params.put("time_stamp", time_stamp);
        params.put("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(image);
        params.put("image", base64Content);
        params.put("scene", "1");
        String sign = TencentAISignSort.getSignature(params, this.app_key);
        params.put("sign", sign);
        result = HttpUtil.post("https://api.ai.qq.com/fcgi-bin/vision/vision_imgidentify", TencentAISignSort.getParams(params));
        return result;
    }

    public String vehicle(String filePath) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.vehicle(image);
    }

    public String visionImgtotext(byte[] image, String session_id) throws Exception {
        String result = "";
        HashMap<String, String> params = new HashMap<String, String>();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        params.put("app_id", this.app_id);
        params.put("time_stamp", time_stamp);
        params.put("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(image);
        params.put("image", base64Content);
        params.put("session_id", session_id);
        String sign = TencentAISignSort.getSignature(params, this.app_key);
        params.put("sign", sign);
        result = HttpUtil.post("https://api.ai.qq.com/fcgi-bin/vision/vision_imgtotext", TencentAISignSort.getParams(params));
        return result;
    }

    public String visionImgtotext(String filePath, String session_id) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.visionImgtotext(image, session_id);
    }

    public String imageFuzzy(byte[] image) throws Exception {
        String result = "";
        HashMap<String, String> params = new HashMap<String, String>();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        params.put("app_id", this.app_id);
        params.put("time_stamp", time_stamp);
        params.put("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(image);
        params.put("image", base64Content);
        String sign = TencentAISignSort.getSignature(params, this.app_key);
        params.put("sign", sign);
        result = HttpUtil.post("https://api.ai.qq.com/fcgi-bin/image/image_fuzzy", TencentAISignSort.getParams(params));
        return result;
    }

    public String imageFuzzy(String filePath) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.imageFuzzy(image);
    }

    public String imageFood(byte[] image) throws Exception {
        String result = "";
        HashMap<String, String> params = new HashMap<String, String>();
        String time_stamp = System.currentTimeMillis() / 1000L + "";
        params.put("app_id", this.app_id);
        params.put("time_stamp", time_stamp);
        params.put("nonce_str", RandomNonceStrUtil.getRandomString());
        String base64Content = Base64Util.encode(image);
        params.put("image", base64Content);
        String sign = TencentAISignSort.getSignature(params, this.app_key);
        params.put("sign", sign);
        result = HttpUtil.post("https://api.ai.qq.com/fcgi-bin/image/image_food", TencentAISignSort.getParams(params));
        return result;
    }

    public String imageFood(String filePath) throws Exception {
        byte[] image = FileUtil.readFileByBytes(filePath);
        return this.imageFood(image);
    }
}

