/*
 * Decompiled with CFR 0.152.
 */
package cn.xpp011.dingrobot.storage;

import cn.xpp011.dingrobot.ExceptionUtil;
import cn.xpp011.dingrobot.message.FailMessage;
import cn.xpp011.dingrobot.storage.FailMessageQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisFailMessageQueue
implements FailMessageQueue {
    private static final Logger log = LoggerFactory.getLogger(RedisFailMessageQueue.class);
    private static String key = "ding-robot:fm-que";
    private final RedisTemplate redisTemplate;
    private final int retry;

    public RedisFailMessageQueue(RedisTemplate redisTemplate, int retry) {
        this.redisTemplate = redisTemplate;
        this.retry = retry;
    }

    public RedisFailMessageQueue(RedisTemplate redisTemplate, String queueKey, int retry) {
        this.redisTemplate = redisTemplate;
        key = queueKey;
        this.retry = retry;
    }

    @Override
    public boolean push(FailMessage message) {
        return this.push(message, this.retry);
    }

    private boolean push(FailMessage message, int retry) {
        try {
            Long res = this.redisTemplate.opsForList().rightPush((Object)key, (Object)message);
            return res >= 1L;
        }
        catch (Exception e) {
            if (ExceptionUtil.isNetworkException(e) && retry > 0) {
                return this.push(message, --retry);
            }
            log.error("push failMessageQueue fail: {}", (Object)e.getMessage());
            throw e;
        }
    }

    @Override
    public FailMessage pop() {
        return this.pop(this.retry);
    }

    private FailMessage pop(int retry) {
        try {
            FailMessage failMessage = (FailMessage)this.redisTemplate.opsForList().leftPop((Object)key);
            return failMessage;
        }
        catch (Exception e) {
            if (ExceptionUtil.isNetworkException(e) && retry > 0) {
                return this.pop(--retry);
            }
            log.error("pop failMessageQueue fail: {}", (Object)e.getMessage());
            throw e;
        }
    }

    @Override
    public long size() {
        return this.redisTemplate.opsForList().size((Object)key);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0L;
    }
}

