/*
 * Decompiled with CFR 0.152.
 */
package cn.xpp011.dingrobot.ratelimiter;

import cn.xpp011.dingrobot.excepation.InternalErrorException;
import cn.xpp011.dingrobot.executor.TaskEnforcer;
import cn.xpp011.dingrobot.executor.TaskParams;
import cn.xpp011.dingrobot.ratelimiter.RateLimiter;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SimpleSlidingWindowRateLimiter
implements RateLimiter {
    private final TaskEnforcer<TaskParams> taskEnforcer;
    private static final long TRY_LOCK_TIMEOUT = 500L;
    private final int limit;
    private final long windowSize;
    private float remainFactor;
    private Lock lock = new ReentrantLock();
    private Deque<Long> queue = new LinkedList<Long>();

    public SimpleSlidingWindowRateLimiter(TaskEnforcer<TaskParams> taskEnforcer, int limit, long windowSize) {
        this(taskEnforcer, limit, windowSize, 0.33f);
    }

    public SimpleSlidingWindowRateLimiter(TaskEnforcer<TaskParams> taskEnforcer, int limit, long windowSize, float remainFactor) {
        this.taskEnforcer = taskEnforcer;
        this.limit = limit;
        this.windowSize = windowSize;
        this.remainFactor = remainFactor;
    }

    @Override
    public boolean tryAcquire() throws InternalErrorException {
        return this.tryAcquire(0L);
    }

    @Override
    public boolean tryAcquireRemain() throws InternalErrorException {
        return this.tryAcquire((long)((float)this.limit * this.remainFactor));
    }

    public boolean tryAcquire(long tryAcquireRemain) throws InternalErrorException {
        try {
            if (this.lock.tryLock(500L, TimeUnit.MILLISECONDS)) {
                long now = System.currentTimeMillis() / 1000L;
                long floor = now - this.windowSize;
                while (!this.queue.isEmpty() && this.queue.peek() < floor) {
                    this.queue.poll();
                }
                int size = this.queue.size();
                if (size < this.limit && (long)(this.limit - size) > tryAcquireRemain) {
                    boolean bl = this.queue.offer(now);
                    return bl;
                }
            }
        }
        catch (InterruptedException e) {
            throw new InternalErrorException("tryAcquire() is interrupted by lock-time-out.", e);
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }
}

