/*
 * Decompiled with CFR 0.152.
 */
package cn.xpp011.dingrobot.ratelimiter;

import cn.xpp011.dingrobot.executor.RedisTaskEnforcer;
import cn.xpp011.dingrobot.executor.SimpleTaskEnforcer;
import cn.xpp011.dingrobot.executor.TaskEnforcer;
import cn.xpp011.dingrobot.ratelimiter.DistributedSlidingWindowRateLimiter;
import cn.xpp011.dingrobot.ratelimiter.RateLimiter;
import cn.xpp011.dingrobot.ratelimiter.RateLimiterType;
import cn.xpp011.dingrobot.ratelimiter.SimpleSlidingWindowRateLimiter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class RateLimiterFactory {
    private static final int LIMIT = 20;
    private static final long WINDOW_SIZE = 60L;
    private static final int OFFSET = 300;
    private static final Map<String, RateLimiter> rateLimiterMap = new ConcurrentHashMap<String, RateLimiter>();

    private RateLimiterFactory() {
    }

    public static RateLimiter getRateLimiter(RateLimiterType type, TaskEnforcer taskEnforcer, String robotName) {
        RateLimiter rateLimiter = rateLimiterMap.getOrDefault(robotName, null);
        if (rateLimiter != null) {
            return rateLimiter;
        }
        if (RateLimiterType.SLIDING_WINDOW.equals((Object)type)) {
            if (taskEnforcer instanceof RedisTaskEnforcer) {
                rateLimiter = new DistributedSlidingWindowRateLimiter(taskEnforcer, robotName, 20, 60L);
            }
            if (taskEnforcer instanceof SimpleTaskEnforcer) {
                rateLimiter = new SimpleSlidingWindowRateLimiter(taskEnforcer, 20, 60L);
            }
        }
        rateLimiterMap.put(robotName, rateLimiter);
        return rateLimiter;
    }

    public static RateLimiter getRateLimiter(String robotName) {
        return rateLimiterMap.getOrDefault(robotName, null);
    }

    public static long getPeriod() {
        return 6300L;
    }

    public static TimeUnit getUnit() {
        return TimeUnit.MILLISECONDS;
    }

    public static long getInitialDelay() {
        return 2000L;
    }
}

