/*
 * Decompiled with CFR 0.152.
 */
package cn.xpp011.dingrobot;

import cn.xpp011.dingrobot.ExceptionUtil;
import cn.xpp011.dingrobot.JsonUtil;
import cn.xpp011.dingrobot.config.DingRobotProperties;
import cn.xpp011.dingrobot.excepation.DingRobotSendMsgFailException;
import cn.xpp011.dingrobot.message.FailMessage;
import cn.xpp011.dingrobot.message.Message;
import cn.xpp011.dingrobot.ratelimiter.RateLimiter;
import cn.xpp011.dingrobot.storage.FailMessageQueue;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.Base64Utils;

public class DingRobotTemplate {
    private static final Logger log = LoggerFactory.getLogger(DingRobotTemplate.class);
    public static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private OkHttpClient client;
    private final String webhook;
    private final String secret;
    private final ExecutorService executor;
    private final RateLimiter rateLimiter;
    private final int retry;
    private final Function<Message, Boolean> FAIL;

    public DingRobotTemplate(OkHttpClient client, DingRobotProperties.RobotProperties robotProperties, int retry, ExecutorService executor, RateLimiter rateLimiter, FailMessageQueue queue, String robotName) {
        this.client = client;
        this.retry = retry;
        this.executor = executor;
        this.rateLimiter = rateLimiter;
        Assert.notNull((Object)robotProperties, (String)"robot\u53c2\u6570\u4fe1\u606f\u7f3a\u5931");
        this.webhook = robotProperties.getWebhook();
        this.secret = robotProperties.getSecret();
        this.FAIL = message -> {
            FailMessage failMessage = new FailMessage(robotName, (Message)message);
            return queue.push(failMessage);
        };
    }

    public Future<Boolean> sendAsync(Message message) {
        return this.sendAsync(message, this.FAIL);
    }

    public Future<Boolean> sendAsync(Message message, Function<Message, Boolean> fail) {
        return this.executor.submit(() -> this.send(message, fail));
    }

    public boolean send(Message message) {
        return this.send(message, this.FAIL);
    }

    public boolean send(Message message, Function<Message, Boolean> fail) {
        try {
            if (!this.rateLimiter.tryAcquire()) {
                log.warn("\u83b7\u53d6\u4ee4\u724c\u5931\u8d25");
                return fail.apply(message);
            }
            return this.doSend(message, this.retry);
        }
        catch (Exception e) {
            log.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a {}", (Object)e.getMessage(), (Object)e);
            return fail.apply(message);
        }
    }

    protected boolean doSend(Message message, int retry) throws NoSuchAlgorithmException, InvalidKeyException, IOException {
        boolean res = true;
        try {
            RequestBody requestBody = RequestBody.create((String)JsonUtil.toJson(message), (MediaType)MEDIA_TYPE_JSON);
            Request request = new Request.Builder().url(this.signatureUrl()).post(requestBody).build();
            Response response = this.client.newCall(request).execute();
            Map<Object, Object> responseBody = Maps.newHashMap();
            if (!response.isSuccessful() || !"ok".equals((responseBody = JsonUtil.toMap(response.body().string())).get("errmsg"))) {
                throw new DingRobotSendMsgFailException((String)responseBody.get("errmsg"));
            }
        }
        catch (Exception e) {
            if (ExceptionUtil.isNetworkException(e) && retry > 0) {
                return this.doSend(message, --retry);
            }
            log.error("sending failed message:{}", (Object)message);
            throw e;
        }
        return res;
    }

    private String signatureUrl() throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        if (StringUtils.isBlank((CharSequence)this.secret)) {
            return this.webhook;
        }
        long timeMillis = System.currentTimeMillis();
        String stringToSign = timeMillis + "\n" + this.secret;
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(this.secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
        byte[] signData = mac.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8));
        String sign = URLEncoder.encode(new String(Base64Utils.encode((byte[])signData)), StandardCharsets.UTF_8.toString());
        String urlToSign = String.format("%s&timestamp=%s&sign=%s", this.webhook, timeMillis, sign);
        return urlToSign;
    }
}

