/*
 * Decompiled with CFR 0.152.
 */
package cn.xpp011.dingrobot.ratelimiter;

import cn.xpp011.dingrobot.excepation.InternalErrorException;
import cn.xpp011.dingrobot.executor.RedisTaskParams;
import cn.xpp011.dingrobot.executor.TaskEnforcer;
import cn.xpp011.dingrobot.executor.TaskParams;
import cn.xpp011.dingrobot.ratelimiter.RateLimiter;

public class DistributedSlidingWindowRateLimiter
implements RateLimiter {
    private static final String SCRIPT_PATH = "lua/SlidingWindowLimiter.lua";
    private final TaskEnforcer<TaskParams> taskEnforcer;
    private final String key;
    private final int limit;
    private final long windowSize;
    private float remainFactor;

    public DistributedSlidingWindowRateLimiter(TaskEnforcer<TaskParams> taskEnforcer, String key, int limit, long windowSize) {
        this(taskEnforcer, key, limit, windowSize, 0.33f);
    }

    public DistributedSlidingWindowRateLimiter(TaskEnforcer<TaskParams> taskEnforcer, String key, int limit, long windowSize, float remainFactor) {
        this.taskEnforcer = taskEnforcer;
        this.key = key;
        this.limit = limit;
        this.windowSize = windowSize;
        this.remainFactor = remainFactor;
    }

    @Override
    public boolean tryAcquire() throws InternalErrorException {
        return this.tryAcquire(0L);
    }

    @Override
    public boolean tryAcquireRemain() throws InternalErrorException {
        return this.tryAcquire((long)((float)this.limit * this.remainFactor));
    }

    private boolean tryAcquire(long tryAcquireRemain) {
        RedisTaskParams params = new RedisTaskParams(this.key, this.limit, this.windowSize, SCRIPT_PATH, tryAcquireRemain);
        Long result = (Long)this.taskEnforcer.execute(params);
        return result >= 1L;
    }
}

