/*
 * Decompiled with CFR 0.152.
 */
package cn.xpp011.dingrobot.executor;

import cn.xpp011.dingrobot.executor.RedisTaskParams;
import cn.xpp011.dingrobot.executor.TaskEnforcer;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.support.ResourceScriptSource;

public class RedisTaskEnforcer
implements TaskEnforcer<RedisTaskParams> {
    private static String KEY_PREFIX = "ding-robot:rl";
    private static String SEPARATOR = ":";
    private RedisTemplate redisTemplate;

    public RedisTaskEnforcer(RedisTemplate redisTemplate) {
        this(KEY_PREFIX, SEPARATOR, redisTemplate);
    }

    public RedisTaskEnforcer(String KEY_PREFIX, String SEPARATOR, RedisTemplate redisTemplate) {
        RedisTaskEnforcer.KEY_PREFIX = KEY_PREFIX;
        RedisTaskEnforcer.SEPARATOR = SEPARATOR;
        this.redisTemplate = redisTemplate;
    }

    public String getKey(String key) {
        return StringUtils.join(Arrays.asList(KEY_PREFIX, key), (String)SEPARATOR);
    }

    @Override
    public <R> R execute(RedisTaskParams params) {
        Object execute;
        String key = this.getKey(params.getKey());
        DefaultRedisScript script = new DefaultRedisScript();
        script.setScriptSource((ScriptSource)new ResourceScriptSource((Resource)new ClassPathResource(params.getScriptPath())));
        script.setResultType(Long.class);
        Object result = execute = this.redisTemplate.execute((RedisScript)script, Arrays.asList(key), new Object[]{params.getLimit(), params.getWindowSize(), params.getTryAcquireRemain()});
        return (R)result;
    }
}

