/*
 * Decompiled with CFR 0.152.
 */
package cn.xpp011.dingrobot.config;

import cn.xpp011.dingrobot.config.DingRobotProperties;
import cn.xpp011.dingrobot.executor.RedisTaskEnforcer;
import cn.xpp011.dingrobot.executor.TaskEnforcer;
import cn.xpp011.dingrobot.storage.FailMessageQueue;
import cn.xpp011.dingrobot.storage.RedisFailMessageQueue;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={RedisConnectionFactory.class})
@ConditionalOnBean(value={RedisConnectionFactory.class})
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
public class RedisDingRobotConfiguration {
    @ConditionalOnMissingBean(name={"dingRobotRedisTemplate"})
    @Bean
    public RedisTemplate dingRobotRedisTemplate(RedisConnectionFactory factory) {
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper om = new ObjectMapper();
        om.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        om.activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.NON_FINAL);
        jackson2JsonRedisSerializer.setObjectMapper(om);
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(factory);
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.setHashKeySerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.setHashValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.afterPropertiesSet();
        return template;
    }

    @ConditionalOnMissingBean(value={FailMessageQueue.class})
    @Bean
    public FailMessageQueue failMessageQueue(RedisTemplate dingRobotRedisTemplate, DingRobotProperties properties) {
        return new RedisFailMessageQueue(dingRobotRedisTemplate, properties.getRetry());
    }

    @ConditionalOnMissingBean(value={TaskEnforcer.class})
    @Bean
    public TaskEnforcer<?> taskEnforcer(RedisTemplate dingRobotRedisTemplate) {
        return new RedisTaskEnforcer(dingRobotRedisTemplate);
    }
}

