/*
 * Decompiled with CFR 0.152.
 */
package cn.xpp011.dingrobot;

import cn.xpp011.dingrobot.DingRobotTemplate;
import cn.xpp011.dingrobot.config.DingRobotProperties;
import cn.xpp011.dingrobot.executor.TaskEnforcer;
import cn.xpp011.dingrobot.ratelimiter.RateLimiter;
import cn.xpp011.dingrobot.ratelimiter.RateLimiterFactory;
import cn.xpp011.dingrobot.ratelimiter.RateLimiterType;
import cn.xpp011.dingrobot.storage.FailMessageQueue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.web.client.RestTemplate;

public class DingRobotFactory {
    private Map<String, DingRobotTemplate> dingRobotMap;
    private ExecutorService executor;
    private FailMessageQueue failMessageQueue;

    public DingRobotFactory(DingRobotProperties properties, ExecutorService executor, FailMessageQueue failMessageQueue, TaskEnforcer taskEnforcer, RateLimiterType rateLimiterType) {
        Map<String, DingRobotProperties.RobotProperties> instance;
        this.executor = executor;
        this.failMessageQueue = failMessageQueue;
        if (properties == null || (instance = properties.getInstance()) == null) {
            return;
        }
        RestTemplate restTemplate = new RestTemplate();
        this.dingRobotMap = new HashMap<String, DingRobotTemplate>();
        for (String name : instance.keySet()) {
            DingRobotProperties.RobotProperties robotProperties = instance.get(name);
            try {
                RateLimiter rateLimiter = RateLimiterFactory.getRateLimiter(rateLimiterType, taskEnforcer, name);
                this.dingRobotMap.put(name, this.creatDingRobot(restTemplate, robotProperties, properties.getRetry(), rateLimiter, name));
            }
            catch (Exception e) {
                throw new BeanCreationException(String.format("exception while creating dingRobot: %s", name, e.getMessage()));
            }
        }
    }

    private DingRobotTemplate creatDingRobot(RestTemplate restTemplate, DingRobotProperties.RobotProperties properties, int retry, RateLimiter rateLimiter, String robotName) throws IllegalArgumentException {
        return new DingRobotTemplate(restTemplate, properties, retry, this.executor, rateLimiter, this.failMessageQueue, robotName);
    }

    public DingRobotTemplate getDingRobot(String dingRobotName) {
        if (!this.dingRobotMap.containsKey(dingRobotName)) {
            throw new RuntimeException(dingRobotName + " dingRobot is not configured");
        }
        return this.dingRobotMap.get(dingRobotName);
    }
}

