/*
 * Decompiled with CFR 0.152.
 */
package cn.xpp011.dingrobot;

import cn.xpp011.dingrobot.DingRobotFactory;
import cn.xpp011.dingrobot.DingRobotTemplate;
import cn.xpp011.dingrobot.ExceptionUtil;
import cn.xpp011.dingrobot.FailMessageHandler;
import cn.xpp011.dingrobot.excepation.AcquireTokenException;
import cn.xpp011.dingrobot.message.FailMessage;
import cn.xpp011.dingrobot.ratelimiter.RateLimiter;
import cn.xpp011.dingrobot.ratelimiter.RateLimiterFactory;
import cn.xpp011.dingrobot.storage.FailMessageQueue;
import cn.xpp011.dingrobot.storage.SimpleFailMessageQueue;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class DefaultFailMessageHandler
implements FailMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultFailMessageHandler.class);
    private static final AtomicBoolean running = new AtomicBoolean(false);
    private final FailMessageQueue queue;
    private final DingRobotFactory dingRobotFactory;
    private final ScheduledExecutorService scheduledExecutorService = this.createDefaultScheduledExecutorService();
    private final int retry;

    public DefaultFailMessageHandler(FailMessageQueue queue, DingRobotFactory dingRobotFactory, int retry) {
        this.queue = queue;
        this.dingRobotFactory = dingRobotFactory;
        this.retry = retry;
    }

    @Override
    public boolean handleMessage(FailMessage failMessage) throws Exception {
        Assert.notNull((Object)failMessage, (String)"failMessage argument is required");
        DingRobotTemplate dingRobot = this.dingRobotFactory.getDingRobot(failMessage.getRobotName());
        boolean success = false;
        try {
            RateLimiter rateLimiter = RateLimiterFactory.getRateLimiter(failMessage.getRobotName());
            if (rateLimiter == null) {
                log.error("\u672a\u627e\u5230robot: {}\u7684\u9650\u6d41\u5668", (Object)failMessage.getRobotName());
                throw new AcquireTokenException("no limiter found for robot " + failMessage.getRobotName());
            }
            if (rateLimiter.tryAcquireRemain()) {
                success = dingRobot.doSend(failMessage.getMessage(), this.retry);
            } else {
                log.info("\u6d88\u606f\u91cd\u8bd5\u5c1d\u8bd5\u83b7\u53d6\u4ee4\u724c\u5931\u8d25dingRobot: {}", (Object)failMessage.getRobotName());
            }
        }
        catch (Exception e) {
            log.error("\u5931\u8d25\u6d88\u606f\u91cd\u8bd5\u5904\u7406\u5931\u8d25\uff1a {}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
        return success;
    }

    @Override
    public FailMessage getFailMessage() {
        return this.queue.pop();
    }

    @Override
    public void start() {
        if (running.compareAndSet(false, true)) {
            this.scheduledExecutorService.scheduleAtFixedRate(() -> {
                FailMessage failMessage;
                try {
                    failMessage = this.getFailMessage();
                    if (failMessage == null) {
                        return;
                    }
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6\u5931\u8d25\u6d88\u606f\u961f\u5217\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
                    return;
                }
                try {
                    log.info("process fail message task running....");
                    boolean success = this.handleMessage(failMessage);
                    log.info("process fail message task ending...., result: {}", (Object)success);
                    if (!success) {
                        this.queue.push(failMessage);
                    }
                }
                catch (Exception e) {
                    if (ExceptionUtil.isNetworkException(e) && failMessage.increment() <= this.retry) {
                        this.queue.push(failMessage);
                    }
                    log.error("\u5904\u7406\u53d1\u9001\u5931\u8d25\u6d88\u606f\u5931\u8d25: {}, message: {}", (Object)e.getMessage(), (Object)failMessage);
                }
            }, RateLimiterFactory.getInitialDelay(), RateLimiterFactory.getPeriod(), RateLimiterFactory.getUnit());
        }
    }

    @Override
    public void close() {
        if (running.compareAndSet(true, false)) {
            this.scheduledExecutorService.shutdown();
            try {
                this.scheduledExecutorService.awaitTermination(5L, TimeUnit.SECONDS);
                if (this.queue instanceof SimpleFailMessageQueue) {
                    while (!this.queue.isEmpty()) {
                        log.error("fail message queue message: {}", (Object)this.queue.pop());
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isRunning() {
        return running.get();
    }

    private ScheduledExecutorService createDefaultScheduledExecutorService() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("ProcessFailMessageTask-Thread-%d").build();
        return new ScheduledThreadPoolExecutor(1, threadFactory);
    }
}

