package cn.xnatural.xnet;

import java.io.IOException;
import java.util.List;

import static cn.xnatural.xchain.IMvc.to;

public interface XioHandler {
    /**
     * 接收有数据id的数据
     * @param fields 消息中多个域的数据
     * @param session 当前会话
     * @throws IOException 流读异常
     */
    void handle(List<XioStream> fields, XioSession session) throws IOException;


    /**
     * 异步执行一个任务
     */
    void exec(Runnable fn);


    /**
     * 获取一个属性
     * @param key 属性key
     * @return 属性值
     */
    Object getAttr(String key);

    /**
     * 服务属性获取
     * @param key 属性key
     * @param type 值类型
     * @param defaultValue 默认值
     * @return 属性值
     * @param <T> 类型
     */
    default <T> T getAttr(String key, Class<T> type, T defaultValue) {
        Object v = getAttr(key);
        if (v == null) return defaultValue;
        return to(v, type);
    }
}
