//package cn.xnatural.xnet;
//
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//
//import java.io.IOException;
//import java.nio.ByteBuffer;
//import java.nio.channels.AsynchronousSocketChannel;
//import java.nio.channels.ClosedChannelException;
//import java.util.*;
//import java.util.concurrent.ConcurrentLinkedQueue;
//import java.util.concurrent.atomic.AtomicBoolean;
//import java.util.function.BiConsumer;
//import java.util.stream.Collectors;
//
///**
// * 一条AIO tcp连接会话, 数据流
// */
//public class XioCoder implements ProtocolDecoder {
//    protected static final Logger log = LoggerFactory.getLogger(XioCoder.class);
//
//    /**
//     *
//     */
//    public final XioHandler handler;
//    /**
//     * 每次接收消息的内存空间
//     */
//    protected final ByteBuffer                buf;
//    /**
//     * 是否正在写入
//     */
//    protected final AtomicBoolean             writing  = new AtomicBoolean(false);
//    /**
//     * Write 任务对列
//     */
//    protected final Queue<WriteRecord>        waiting  = new ConcurrentLinkedQueue<>();
//    /**
//     * 当前正在读的数据记录
//     */
//    protected ReadRecord rr;
//    protected final HttpIOSession ioSession;
//
//
//    /**
//     * 创建 {@link XioCoder}
//     * @param ioSession {@link AsynchronousSocketChannel}
//     * @param handler {@link XioHandler}
//     */
//    public XioCoder(HttpIOSession ioSession, XioHandler handler) {
//        if (ioSession == null) throw new NullPointerException("Param ioSession required");
//        if (handler == null) throw new NullPointerException("Param delegate required");
//        this.ioSession = ioSession;
//        this.handler = handler;
//        this.buf = ByteBuffer.allocate(handler.getAttr("receiveMsgBufferSize", Integer.class, 1024 * 1024));
//    }
//
//
//    /**
//     * 数据读取
//     * 格式:
//     *  多少域[byte],[第一域长度[int], 第二域长度[int]...], [第一域内容,第二域内容...]
//     */
//    public void decode(ByteBuffer buf) {
//        if (!buf.hasRemaining()) { buf.clear(); return; } // 是否有可以读的数据, 没有就清除状态
//        // 新消息开始
//        if (rr == null) {
//            rr = createReadRecord(buf.get()); // 创建新的临时读数据记录并读取新消息有多少域
//            if (buf.remaining() < rr.fieldCnt * 4) { buf.compact(); return; } // 不够读, 每个域的长度必须一起读
//            // 读每个域的长度
//            for (byte i = 0; i < rr.fieldCnt; i++) {
//                rr.fields.add(new XioStream(buf.getInt()));
//            }
//        }
//
//        // 取出当前正在读取的域
//        XioStream field = rr.fields.stream().filter(f -> f.leftReceived() > 0).findFirst().orElse(null);
//        if (field == null) { // 一个完整数据消息已读完(所有域已读完)
//            rr = null;
//            decode(buf); return;
//        }
//
//        // 填充当前域
//        byte[] bs = new byte[(int) Math.min(field.leftReceived(), buf.remaining())];
//        buf.get(bs);
//        field.addStream(bs);
//
//        // 如果是第一个域, 让业务处理先(一边读一边处理)
//        if (rr.fields.get(0) == field && field.received <= bs.length) { // 只能执行一次: 第一个域第一次读了数据
//            handler.exec(() -> { // 先分派新的线程处理数据, 最后域XioStream会继续接收未完成的数据(一边接收一边处理)
//                try {
//                    handler.handle(new ArrayList<>(rr.fields), this); // 新创建ArrayList是为了避免,删减引起数据读不全错误
//                } catch (Exception ex) {
//                    log.error(getClass().getName() + " receive error", ex);
//                }
//            });
//        }
//        decode(buf);
//    }
//
//
//    /**
//     * 读一条新的数据的开始
//     */
//    protected ReadRecord createReadRecord(byte fieldCnt) { return new ReadRecord(fieldCnt); }
//
//
//    /**
//     * 写入消息到流
//     * @param fields 多域数据
//     * @param failFn 失败回调函数
//     * @param okFn 成功回调函数
//     */
//    public void write(List<XioStream> fields, BiConsumer<Throwable, XioCoder> failFn, Runnable okFn) {
//        if (fields == null) throw new IllegalArgumentException("Param fields required");
//        if (ioSession.closed.get() || !ioSession.channel.isOpen()) {
//            if (failFn == null) {
//                log.error("Already closed. " + this);
//            } else {
//                failFn.accept(new ClosedChannelException(), this);
//            }
//        }
//        WriteRecord record = new WriteRecord(fields, failFn, okFn);
//        if (ioSession.closed.get() || !ioSession.channel.isOpen()) { // 关闭时, 通知剩下没发送的record#failFn
//            if (record.failFn != null) record.failFn.accept(new ClosedChannelException(), this);
//        }
//        else {
//            while (true) {
//                ByteBuffer buf = record.poll();
//                if (buf == null) break;
//                ioSession.write(buf);
//            }
//        }
//    }
//
//    /**
//     * 写入消息到流
//     * @param fields 多域数据
//     */
//    public void write(XioStream... fields) {
//        if (fields == null || fields.length < 1) throw new IllegalArgumentException("Param fields required");
//        write(Arrays.asList(fields), null, null);
//    }
//
//    /**
//     * 写入消息到流
//     * @param data 要写入的数据
//     * @param failFn 失败回调函数
//     * @param okFn 成功回调函数
//     */
//    public void write(byte[] data, BiConsumer<Throwable, XioCoder> failFn, Runnable okFn) {
//        if (data == null || data.length < 1) throw new IllegalArgumentException("Param data required");
//        write(Collections.singletonList(new XioStream(data)), failFn, okFn);
//    }
//
//    /**
//     * {@link #write(byte[], BiConsumer, Runnable)}
//     * @param fields 数据
//     */
//    public void write(byte[]... fields) {
//        if (fields == null || fields.length < 1) throw new IllegalArgumentException("Param fields required");
//        List<XioStream> x = new LinkedList<>();
//        for (byte[] field : fields) x.add(new XioStream(field));
//        write(x, null, null);
//    }
//
//    /**
//     * {@link #write(List, BiConsumer, Runnable)}
//     * @param fields 数据
//     */
//    public void write(List<byte[]> fields) {
//        if (fields == null || fields.isEmpty()) throw new IllegalArgumentException("Param fields required");
//        write(fields.stream().map(XioStream::new).collect(Collectors.toList()), null, null);
//    }
//
//
//    /**
//     * 每次写入创建一个
//     */
//    protected class WriteRecord implements AutoCloseable {
//        protected final BiConsumer<Throwable, XioCoder> failFn;
//        protected final Runnable        okFn;
//        // 每个域的数据内容
//        protected final List<XioStream> fields;
//        // 分批写时,每批写的大小
//        protected final int             perSendLen = handler.getAttr("perSendLen", Integer.class, 1024 * 10);
//
//        public WriteRecord(List<XioStream> fields, BiConsumer<Throwable, XioCoder> failFn, Runnable okFn) {
//            this.failFn = failFn;
//            this.okFn = okFn;
//            this.fields = new LinkedList<>(fields);
//            if (fields.isEmpty()) throw new IllegalArgumentException("Not found field");
//            if (fields.size() > Byte.MAX_VALUE) throw new IllegalArgumentException("Too many field, must < " + Byte.MAX_VALUE);
//        }
//
//        /**
//         * 弹出下一个需要写入通道的数据
//         * @return null: 证明已没有可写的数据了
//         */
//        ByteBuffer poll() {
//            XioStream field = fields.stream().filter(o -> !o.isEnd()).findFirst().orElse(null);
//            if (field == null) return null; // 数据已发送完
//            ByteBuffer data;
//            try {
//                if (fields.get(0).readCnt == 0) { // 首块数据
//                    byte[] bs = new byte[field.length > perSendLen ? perSendLen : (int) field.length];
//                    data = ByteBuffer.allocate(field.read(bs) + 1 + (fields.size() * 4));
//                    // 多少域[byte],[第一域长度[int], 第二域长度[int]...], [第一域内容,第二域内容...]
//                    data.put((byte) fields.size()); // 多少域
//                    fields.forEach(f -> data.putInt((int) f.length)); // 每个域的长度
//                    data.put(bs).flip();
//                } else {
//                    long left = field.available(); // 流剩下的没读完
//                    byte[] bs = new byte[left > perSendLen ? perSendLen : (int) left];
//                    field.read(bs);
//                    data = ByteBuffer.wrap(bs);
//                }
//            } catch (IOException ex) {
//                throw new RuntimeException(ex);
//            }
//            return data;
//        }
//
//        @Override
//        public void close() {
//            for (XioStream field : fields) field.close();
//        }
//    }
//
//
//    /**
//     * 数据读取过程临时变量
//     */
//    protected class ReadRecord implements AutoCloseable {
//        // 消息有多少域
//        protected final byte            fieldCnt;
//        // 多域数据流
//        protected final List<XioStream> fields;
//
//        public ReadRecord(byte fieldCnt) {
//            if (fieldCnt < 1) throw new RuntimeException("Msg no field");
//            this.fieldCnt = fieldCnt;
//            this.fields = new ArrayList<>(fieldCnt);
//        }
//
//        @Override
//        public void close() {
//            for (XioStream stream : fields) stream.close();
//        }
//    }
//}
