package cn.xnatural.xnet;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.channels.AsynchronousSocketChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;

/**
 * {@link XNet} 基类
 */
public abstract class XNetBase implements AutoCloseable {
    protected final XNet xNet;


    public XNetBase(XNet xNet) {
        this.xNet = xNet;
    }

    protected void start() {}

    @Override
    public void close() {}

    protected void exec(Runnable fn) {
        xNet.exec(fn);
    }


    /**
     * 接收连接
     * @param channel 连接
     * @param confirm 协议确认回调函数。如果成功, 则回调true
     */
    protected void accept(AsynchronousSocketChannel channel, Consumer<Boolean> confirm) {
        confirm.accept(false);
    }


    public Object getAttr(String key) { return xNet.getAttr(key); }


    /**
     * 获取本机 所有 ip 地址
     */
    public static List<String> ipv4s() {
        List<String> ret = new LinkedList<>();
        try {
            for (Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces(); en.hasMoreElements(); ) {
                NetworkInterface current = en.nextElement();
                if (!current.isUp() || current.isLoopback() || current.isVirtual()) continue;
                Enumeration<InetAddress> addresses = current.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    if (addr.isLoopbackAddress()) continue;
                    if (addr instanceof Inet4Address) {
                        ret.add(addr.getHostAddress());
                    }
                }
            }
        } catch (SocketException e) {
            XNet.log.error("", e);
        }
        return ret;
    }


    /**
     * sha1 加密
     * @param bs 被加密byte[]
     * @return 加密后的byte[]
     */
    public static byte[] sha1(byte[] bs) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(bs);
            return digest.digest();
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}
