package cn.xnatural.xnet;

import cn.xnatural.xchain.RouteHandler;

import java.lang.reflect.InvocationTargetException;
import java.util.Base64;

import static cn.xnatural.xnet.XNetBase.sha1;

public abstract class WSHandler extends RouteHandler<HttpContext> {

    public static final String WEB_SOCKET = "websocket";

    public WSHandler(String path) {
        super(WEB_SOCKET, path);
    }


    @Override
    public boolean handle(HttpContext hCtx) throws Throwable {
        try {
            // 改变IO流数据的解析为WebSocket的解析器
            hCtx.request().ioSession().protocol = hCtx.param(WebSocket.class);

            // WebSocket响应
            HttpServer srv = hCtx.param(HttpServer.class);
            hCtx.response.status(101); // 响应握手
            hCtx.response.header("Connection", "Upgrade");
            hCtx.response.header("Upgrade", WEB_SOCKET);
            hCtx.response.header("Sec-WebSocket-Accept", Base64.getEncoder().encodeToString(sha1(
                    (hCtx.request().getHeader("Sec-WebSocket-Key") + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").getBytes(srv.getCharset())
            )));
            hCtx.response.header("Sec-WebSocket-Location", "ws://" + (hCtx.request().getHost() == null ? srv.xNet.getHp() : hCtx.request().getHost()) + "/" + hCtx.request().getPath());
            hCtx.render();

            doHandle(hCtx); // 派发到具体的 @WS 注释到的处理器
        } catch (InvocationTargetException ex) {
            hCtx.close();
            throw ex.getCause();
        }
        return true;
    }


    /**
     * 执行 path 路径对应的处理
     */
    protected abstract void doHandle(HttpContext hCtx) throws Throwable;


    @Override
    public String toString() {
        return WS.class.getSimpleName() + "[" +
                (protocol.isEmpty() ? "" : "(" + protocol +")") +
                (method.isEmpty() ? "" : "(" + String.join(",", method) + ")") +
                ("/" + path).replace("//", "/") + "]";
    }
}
